<div id="pointMap-{$carrierId}" class="pointMap">
    <div id="map-{$carrierId}" style="height: 400px;"></div>
    <input type="hidden" id="selectedPoint-{$carrierId}" name="selected_point" value="">
    <input type="hidden" id="selectedPointName-{$carrierId}" name="selected_point_name" value="">
    <div class="search-control" style="position: absolute; top: 10px; right: 10px; z-index: 1000;">
        <input type="text" id="addressSearch-{$carrierId}" placeholder="Wyszukaj adres...">
        <button type="button" class="btn btn-primary" id="searchButton-{$carrierId}">Szukaj</button>
        <div id="searchSuggestions-{$carrierId}" class="suggestions" style="display: none;"></div>
    </div>
    <button type="button" class="btn btn-primary" id="updatePointsButton-{$carrierId}" style="position: absolute; bottom: 10px; left: 50%; transform: translateX(-50%); z-index: 1000; display: none;">
        Pokaż punkty
    </button>
</div>
<script>
    {literal}
    document.addEventListener("DOMContentLoaded", function() {
        var carrierId = '{/literal}{$carrierId}{literal}',
            pointsUrl = '{/literal}{$pointsUrl}{literal}',
            savePointUrl = '{/literal}{$savePointUrl}{literal}',
            mapContainerId = 'map-' + carrierId,
            selectedPointId = 'selectedPoint-' + carrierId,
            addressSearchId = 'addressSearch-' + carrierId,
            searchButtonId = 'searchButton-' + carrierId,
            suggestionsBoxId = 'searchSuggestions-' + carrierId,
            updatePointsButtonId = 'updatePointsButton-' + carrierId;
        window.epakaMaps = window.epakaMaps || {};
        var map;
        if (window.epakaMaps[mapContainerId]) {
            map = window.epakaMaps[mapContainerId];
        } else {
            map = L.map(mapContainerId).setView([52.2298, 21.0122], 11);
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '© OpenStreetMap contributors'
            }).addTo(map);
            window.epakaMaps[mapContainerId] = map;
        }
        var markers = [],
            lastGeocodeLatLon = null,
            skipNextMoveend = false;
        function getIconForCourier(courierId) {
            var courierIcons = {
                'inpost': 'https://epaka.pl/img/kurierIkony/inpost-paczkomaty-logo.svg',
                'orlen': 'https://epaka.pl/img/kurierIkony/orlen-paczka.svg',
                'dpd': 'https://epaka.pl/img/kurierIkony/dpd-pickup-logo.svg',
                'dhl': 'https://epaka.pl/img/kurierIkony/dhl-servicePoint-logo.svg',
                'fedex': 'https://epaka.pl/img/kurierIkony/fedex-Punkt-logo.svg',
                'novaPoshta': 'https://epaka.pl/img/kurierIkony/nova-poshta-logo.svg'
            };
            var iconUrl;
            switch(parseInt(courierId)) {
                case 6:
                    iconUrl = courierIcons.inpost;
                    break;
                case 11:
                    iconUrl = courierIcons.orlen;
                    break;
                case 20:
                    iconUrl = courierIcons.dpd;
                    break;
                case 22:
                    iconUrl = courierIcons.dhl;
                    break;
                case 45:
                    iconUrl = courierIcons.fedex;
                    break;
                case 53:
                    iconUrl = courierIcons.novaPoshta;
                    break;
                default:
                    iconUrl = null;
            }
            if (!iconUrl) {
                return L.icon({
                    iconUrl: 'https://unpkg.com/leaflet@1.9.3/dist/images/marker-icon.png',
                    iconSize: [25, 41],
                    iconAnchor: [12, 41],
                    popupAnchor: [1, -34],
                    shadowUrl: 'https://unpkg.com/leaflet@1.9.3/dist/images/marker-shadow.png',
                    shadowSize: [41, 41]
                });
            }
            return L.icon({
                iconUrl: iconUrl,
                iconSize: [32, 32],
                iconAnchor: [16, 32],
                popupAnchor: [0, -32]
            });
        }
        function getWorkHours(hours) {
            if (!hours || !Array.isArray(hours)) return '';
            return hours.map(function(h) {
                return h.day_of_week + ": " + (h.open_from || 'Zamknięte') + " - " + (h.open_to || '');
            }).join('<br>');
        }
        function loadPoints() {
            var cod = '{/literal}{$isCod}{literal}'
            var center = map.getCenter();
            fetch(pointsUrl, {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({
                    courier: parseInt(carrierId),
                    lat: center.lat,
                    lon: center.lng,
                    showMachines: true,
                    isCod: cod === '1'
                })
            })
            .then(function(response) { return response.json(); })
            .then(function(data) {
                markers.forEach(function(marker) { map.removeLayer(marker); });
                markers = [];
                if (data && Array.isArray(data)) {
                    var icon = getIconForCourier(carrierId);
                    data.forEach(function(point) {
                        if (point.lat && point.lon) {
                            var buttonHtml = "<button type='button' class='btn btn-primary btn-sm mt-2' onclick='wybierzPunkt("
                                + JSON.stringify(parseInt(carrierId)) + ", "
                                + JSON.stringify(point.point_id) + ", "
                                + JSON.stringify(point.name) + ")'>Wybierz</button>";
                            var marker = L.marker([point.lat, point.lon], { icon: icon })
                                .addTo(map)
                                .bindPopup(
                                    '<strong>' + point.name + '</strong><br>' +
                                    point.address.street + ' ' + point.address.building_number + '<br>' +
                                    point.address.postal_code + ' ' + point.address.city + '<br>' +
                                    '<hr>' +
                                    '<strong>Czas pracy:</strong><br>' +
                                    getWorkHours(point.open_hours) + '<br>' +
                                    buttonHtml
                                );
                            markers.push(marker);
                        }
                    });
                    if (lastGeocodeLatLon) {
                        highlightNearestPoints(lastGeocodeLatLon[0], lastGeocodeLatLon[1]);
                    } else {
                        markers.forEach(function(m) { m.setOpacity(1); });
                    }
                }
            })
            .catch(function(error) { console.error("Błąd podczas wczytywania punktów:", error); });
        }
        function highlightNearestPoints(lat, lon) {
            var radius = 300;
            markers.forEach(function(marker) {
                var markerLatLng = marker.getLatLng();
                var distance = map.distance(markerLatLng, L.latLng(lat, lon));
                marker.setOpacity((distance <= radius) ? 1 : 1);
            });
        }
        window.wybierzPunkt = function(carrierId, pointId, pointName) {
            var elId = 'selectedPoint-' + carrierId;
            var elNameId = 'selectedPointName-' + carrierId;
            var inputId = document.getElementById(elId);
            var inputName = document.getElementById(elNameId);
            if(inputId && inputName) {
                inputId.value = pointId;
                inputName.value = pointName;
            } else {
            }
            fetch(savePointUrl, {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({
                    selected_point: pointId,
                    selected_point_name: pointName
                })
            })
            .then(function(response) { return response.json(); })
            .then(function(data) {
                var carriersExtraBlocks = document.querySelectorAll('.epaka-map-container');
                [...carriersExtraBlocks].forEach(function (carrier){
                    if(carrier.getAttribute('data-carrier-id') == carrierId) {
                        var rowCarrierElement = carrier?.parentElement?.previousElementSibling.querySelector('label > div')
                        if(rowCarrierElement) {
                            var isHasPointBlock = false,
                                pointBlock =  null;
                            Array.from(rowCarrierElement.children).forEach(function(carrierOption) {
                                if (carrierOption.classList.contains('point')) {
                                    isHasPointBlock = true;
                                    pointBlock = carrierOption;
                                }
                            });
                            if(!isHasPointBlock) {
                                rowCarrierElement.insertAdjacentHTML('beforeend', `
                                <div class="col-sm-3 col-xs-12 point">
                                  <span class="carrier-point">${pointId} / ${pointName}</span>
                                </div>
                            `)
                            } else {
                                pointBlock.innerText = `${pointId} / ${pointName}`
                            }
                            carrier.classList.remove('active')
                        }
                    }
                });
            })
            .catch(function(err) {
                console.error("Savepoint error:", err);
            });
        };
        var searchInput = document.getElementById(addressSearchId);
        var searchButton = document.getElementById(searchButtonId);
        var suggestionsBox = document.getElementById(suggestionsBoxId);
        var typingTimeout = null;
        function fetchSuggestions(query) {
            var url = 'https://nominatim.openstreetmap.org/search?format=json&addressdetails=1&limit=5&q=' + encodeURIComponent(query);
            fetch(url)
                .then(function(response) { return response.json(); })
                .then(function(data) {
                    if (Array.isArray(data) && data.length > 0) {
                        showSuggestions(data);
                    } else {
                        clearSuggestions();
                    }
                })
                .catch(function(error) {
                    console.error("Błąd przy pobieraniu sugestii:", error);
                    clearSuggestions();
                });
        }

        function showSuggestions(data) {
            suggestionsBox.innerHTML = '';
            suggestionsBox.style.display = 'block';
            data.forEach(function(item) {
                var displayName = item.display_name;
                var div = document.createElement('div');
                div.textContent = displayName;
                div.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    searchInput.value = displayName;
                    clearSuggestions();
                    geocodeAddress(displayName);
                });
                suggestionsBox.appendChild(div);
            });
        }

        function clearSuggestions() {
            suggestionsBox.innerHTML = '';
            suggestionsBox.style.display = 'none';
        }
        searchInput.addEventListener('input', function(e) {
            var query = e.target.value.trim();
            clearTimeout(typingTimeout);
            if (query.length < 3) {
                clearSuggestions();
                return;
            }
            typingTimeout = setTimeout(function() {
                fetchSuggestions(query);
            }, 300);
        });
        searchButton.addEventListener('click', function() {
            var query = searchInput.value.trim();
            if (query) {
                clearSuggestions();
                geocodeAddress(query);
            }
        });
        searchInput.addEventListener('keydown', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                var query = searchInput.value.trim();
                if (query) {
                    clearSuggestions();
                    geocodeAddress(query);
                }
            }
        });
        function geocodeAddress(query) {
            skipNextMoveend = true;
            var url = 'https://nominatim.openstreetmap.org/search?format=json&q=' + encodeURIComponent(query);
            fetch(url)
                .then(function(response) { return response.json(); })
                .then(function(data) {
                    if (data && data.length > 0) {
                        var lat = parseFloat(data[0].lat);
                        var lon = parseFloat(data[0].lon);
                        lastGeocodeLatLon = [lat, lon];
                        map.setView([lat, lon], 15);
                        document.getElementById(updatePointsButtonId).style.display = 'none';
                        loadPoints();
                    } else {
                        alert("Nie znaleziono żadnego adresu.");
                    }
                })
                .catch(function(error) { console.error("Błąd geokodowania:", error); });
        }
        var timeout;
        map.on('moveend', function() {
            if (skipNextMoveend) {
                skipNextMoveend = false;
                return;
            }
            clearTimeout(timeout);
            timeout = setTimeout(function() {
                document.getElementById(updatePointsButtonId).style.display = 'block';
            }, 500);
        });
        document.getElementById(updatePointsButtonId).addEventListener('click', function() {
            loadPoints();
            this.style.display = 'none';
        });
        loadPoints();
    });
    {/literal}
</script>
