if (!window.epakaScriptsLoaded) {
    function reinitializeMap(courierId) {
        var mapContainerId = 'map-' + courierId;
        if (window.epakaMaps && window.epakaMaps[mapContainerId]) {
            window.epakaMaps[mapContainerId].invalidateSize();
        }
    }
    window.epakaScriptsLoaded = true;
    const allDeliveryRadios = document.querySelectorAll('input[type="radio"][name^="delivery_option"]');
    allDeliveryRadios.forEach(function(radio) {
        radio.addEventListener("change", function() {
            if (this.checked) {
                document.querySelectorAll(".epaka-map-container").forEach(function(mapContainer) {
                    mapContainer.classList.remove("active");
                    setTimeout(function() {
                        reinitializeMap(mapContainer.getAttribute('data-carrier-id'));
                    }, 1000);
                });
                const carrierExtraContent = this.closest(".delivery-option");
                if (carrierExtraContent) {
                    const epakaCarrierBlock = carrierExtraContent.nextElementSibling
                        ? carrierExtraContent.nextElementSibling.querySelector(".epaka-map-container")
                        : null;
                    if (epakaCarrierBlock) {
                        epakaCarrierBlock.classList.add("active");
                    }
                }
            }
        });
    });
}





