'use strict';
window.addEventListener('DOMContentLoaded', function() {
    const templateSubmit = document.querySelector('.shipping-submit');
    if(templateSubmit) templateSubmit.disabled = true;
    const form = templateSubmit?.closest('form');
    if (templateSubmit && form) {
        templateSubmit.disabled = true;
        form.addEventListener('submit', function (event) {
            templateSubmit.disabled = true;
        });
    }
    activateEpakaSidebarTabs();
    function activateEpakaSidebarTabs() {
        const urlPath = window.location.pathname;
        if (urlPath.includes('/epaka')) {
            const parentTab = document.querySelector('#subtab-AdminEpakaParent');
            if (parentTab) {
                parentTab.classList.add('link-active', 'open', 'ul-open');
                const submenu = parentTab.querySelector('.submenu');
                if (submenu) submenu.style.display = 'block';
                const arrow = parentTab.querySelector('.sub-tabs-arrow');
                if (arrow) arrow.textContent = 'keyboard_arrow_up';
                const currentTab = document.querySelector('#subtab-AdminEpakaTemplates');
                if (currentTab) currentTab.classList.add('link-active');
            }
        }
    }
    function showAlert(containerId, message = 'Wystąpił błąd. Prosimy o kontakt z serwisem epaka.pl', type = 'danger') {
        const container = document.getElementById(containerId)
        if (!container) return;
        const alertHTML =
            `
            <div class="alert alert-${type} d-print-none" role="alert">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true"><i class="material-icons">close</i></span>
                </button>
                <div class="alert-text">
                    <p>${message}</p>
                </div>
            </div>
        `;
        container.insertAdjacentHTML('afterbegin', alertHTML);
        const alertElement = container.querySelector('.alert');
        const closeButton = alertElement.querySelector('.close');
        if (closeButton) {
            closeButton.addEventListener('click', () => alertElement.remove());
        }
        setTimeout(() => {
            if (alertElement && alertElement.parentNode) {
                alertElement.remove();
            }
        }, 10000);
    }
    const epakaModule = document.getElementById('epaka-module');
    const deliveryParcelTypeInputs = document.querySelectorAll('#delivery-block .custom-radio input'),
          deliveryParcelParametersInputs = document.querySelectorAll('#delivery-block .input-group input, #delivery-block .input-group select'),
          deliveryParcelParametersRadio = document.querySelectorAll('#delivery-block .radio input'),
          deliveryBlock = document.querySelector('#delivery-block .form-group-wrapper'),
          shippingPreloaderClass = 'shipping-preload',
          orderPreloaderClass = 'order-preload';
    if(deliveryBlock) {
        const deliveryBlockContent = deliveryBlock.getElementsByClassName('form-group')[0],
            courierBlock = document.querySelector('#courier-block'),
            courierBlockContent = courierBlock.getElementsByClassName('block-content')[0],
            additionalCourierSettingsBlock = document.querySelector('#courier-settings-block'),
            additionalCourierSettingsBlockContent = additionalCourierSettingsBlock.getElementsByClassName('block-content')[0],
            priceToFrontendBlock = document.querySelector('#price-to-frontend-block'),
            priceToFrontendBlockContent = priceToFrontendBlock.getElementsByClassName('block-content')[0],
            priceToFrontendWrapperName = priceToFrontendBlock.getElementsByClassName('card-header')[0],
            defaultSenderBlock = document.querySelector('#default-sender-block'),
            defaultSenderBlockContent = defaultSenderBlock.getElementsByClassName('block-content')[0];
        const inputFields = [...deliveryParcelParametersInputs].filter(elem => elem.tagName.toLowerCase() === 'input'),
              selectFields = [...deliveryParcelParametersInputs].filter(elem => elem.tagName.toLowerCase() === 'select'),
              totalInputsToFill = inputFields.length;
        let filledInputsCount = 0,
            isFetchingCouriers = false
        const isEditActionPage = typeof epakaCarrierId !== 'undefined';
        if(!isEditActionPage) {
            inputFields.forEach(input => {
                let wasFilled = false;
                let isAdded = true;
                input.addEventListener('input', function() {
                    const isFilled = input.value.length > 0;
                    switch (true) {
                        case !wasFilled && isFilled:  filledInputsCount++; break;
                        case wasFilled && !isFilled:  filledInputsCount--; break;
                    }
                    wasFilled = isFilled;
                    const deliveryConfirmInputsButton = document.getElementsByClassName('delivery-inputs-confirm')[0];
                    if(filledInputsCount === totalInputsToFill) {
                        if(!deliveryConfirmInputsButton) {
                            deliveryBlockContent.insertAdjacentHTML('beforeend', `
                                <button type="button" class="btn-default btn delivery-inputs-confirm mt-4 outline-0">Potwierdzić</button>
                            `);
                        }
                        const button = document.getElementsByClassName('delivery-inputs-confirm')[0];
                        button.replaceWith(button.cloneNode(true));
                        document.getElementsByClassName('delivery-inputs-confirm')[0].addEventListener('click', function() {
                            (async () => {await toggleCourierVisibility(filledInputsCount, totalInputsToFill);})();
                        });
                    } else if (deliveryConfirmInputsButton) {
                        deliveryConfirmInputsButton.remove();
                        hiderAndClearCourierContent();
                        hiderAndClearAdditionalCourierContent();
                        hiderAndClearPriceToFrontendContent();
                    }
                })
            });
        } else {
            const totalInputsToFill = inputFields.length;
            let filledInputsCount = totalInputsToFill;
            deliveryBlockContent.insertAdjacentHTML('beforeend', `
           <button type="button" class="btn-default btn delivery-inputs-confirm mt-4 outline-0">Potwierdzić</button>
       `);
            document.getElementsByClassName('delivery-inputs-confirm')[0].addEventListener('click', function() {
                (async () => {await toggleCourierVisibility(filledInputsCount, totalInputsToFill);})();
            });
            inputFields.forEach(input => {
                input.addEventListener('input', function() {
                    if(input.value.length === 0) {
                        filledInputsCount--;
                    } else if(input.value.length > 0 && filledInputsCount < totalInputsToFill) {
                        filledInputsCount++;
                    }
                    const deliveryConfirmInputsButton = document.getElementsByClassName('delivery-inputs-confirm')[0];
                    if(filledInputsCount < totalInputsToFill && deliveryConfirmInputsButton) {
                        deliveryConfirmInputsButton.remove();
                        hiderAndClearCourierContent();
                        hiderAndClearAdditionalCourierContent();
                        hiderAndClearPriceToFrontendContent();
                    } else if(filledInputsCount === totalInputsToFill && !deliveryConfirmInputsButton) {
                        deliveryBlockContent.insertAdjacentHTML('beforeend', `
                           <button type="button" class="btn-default btn delivery-inputs-confirm mt-4 outline-0">Potwierdzić</button>
                       `);
                        document.getElementsByClassName('delivery-inputs-confirm')[0].addEventListener('click', function() {
                            (async () => {await toggleCourierVisibility(filledInputsCount, totalInputsToFill);})();
                        });
                    }
                });
            });
        }


        selectFields.forEach(select => {
            select.addEventListener('change', function() {
                hiderAndClearCourierContent();
                hiderAndClearAdditionalCourierContent();
                hiderAndClearPriceToFrontendContent();
                // (async () => {await toggleCourierVisibility(filledInputsCount, totalInputsToFill);})();
                templateSubmit.disabled = true
                templateSubmit.classList.add('no-active')
            })
        });
        deliveryParcelParametersRadio.forEach(select => {
            select.addEventListener('change', function() {
                hiderAndClearCourierContent();
                hiderAndClearAdditionalCourierContent();
                hiderAndClearPriceToFrontendContent();
                templateSubmit.disabled = true
                templateSubmit.classList.add('no-active')
            })
        });
        inputFields.forEach(input => {
            input.addEventListener('input', function() {
                hiderAndClearCourierContent();
                hiderAndClearAdditionalCourierContent();
                hiderAndClearPriceToFrontendContent();
                templateSubmit.disabled = true
                templateSubmit.classList.add('no-active')
            });
        });
        if(isEditActionPage) (async () => {await fetchCouriers();})();
        (async () => {await fetchDefaultSenderBlock();})();
        async function fetchDefaultSenderBlock() {
            if(isEditActionPage) {
                fetch(adminDefaultSenderControllerUrl, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        epakaCarrierId: epakaCarrierId
                    })
                })
                    .then(response => {
                        if (!response.ok) throw new Error(`HTTP error! Status: ${response.status}`);
                        return response.text();
                    })
                    .then(html => {
                        defaultSenderBlockContent.insertAdjacentHTML('beforeend', html);
                        defaultSenderBlock.classList.remove('d-none');
                    });
            } else {
                fetch(adminDefaultSenderControllerUrl)
                    .then(response => {
                        if (!response.ok) throw new Error(`HTTP error! Status: ${response.status}`);
                        return response.text();
                    })
                    .then(html => {
                        defaultSenderBlockContent.insertAdjacentHTML('beforeend', html);
                        defaultSenderBlock.classList.remove('d-none');
                    })
            }
        }
        async function toggleCourierVisibility(filledInputsCount, totalInputsToFill) {
            if (filledInputsCount === totalInputsToFill) {
                hiderAndClearCourierContent();
                hiderAndClearAdditionalCourierContent();
                hiderAndClearPriceToFrontendContent();
                await fetchCouriers();
            } else {
                hiderAndClearCourierContent();
                hiderAndClearAdditionalCourierContent();
                hiderAndClearPriceToFrontendContent();
            }
        }
        function buildCourierRequestData() {
            const deliveryParcelTypeInputs = document.querySelectorAll('#delivery-block input, #delivery-block [data-api-select-name="packageType"], #delivery-block [data-api-select-name="senderCountry"], #delivery-block [data-api-select-name="receiverCountry"]');
            const requestBody = {
                packages: [{}]
            };
            deliveryParcelTypeInputs.forEach(function(elem) {
                if (elem.type === 'radio') {
                    if (elem.checked) {
                        requestBody['shippingType'] = elem.value.toLowerCase();
                    }
                } else if(elem.tagName.toLowerCase() === 'select') {
                    switch (true) {
                        case elem.getAttribute('data-api-select-name') === 'packageType': {
                            requestBody.packages[0].packageType = elem.value.toLowerCase();
                            break;
                        }
                        case elem.getAttribute('data-api-select-name') === 'senderCountry': {
                            requestBody['senderCountry'] = elem.value
                            break;
                        }
                        case elem.getAttribute('data-api-select-name') === 'receiverCountry': {
                            requestBody['receiverCountry'] = elem.value
                            break;
                        }
                    }
                } else {
                    const match = elem.name.match(/\[(.*?)\]/);
                    switch (true) {
                        case match[1] === 'height': {
                            requestBody.packages[0].height = +elem.value;
                            break;
                        }
                        case match[1] === 'weight': {
                            requestBody.packages[0].weight = +elem.value;
                            break;
                        }
                        case match[1] === 'length': {
                            requestBody.packages[0].length = +elem.value;
                            break;
                        }
                        case match[1] === 'width': {
                            requestBody.packages[0].width = +elem.value;
                            break;
                        }
                    }
                }
            });

            if(isEditActionPage) {
                if( typeof epakaCurrentCourierId === 'undefined') {
                    showAlert('epaka-module')
                    console.error('The ‘epakaCurrentCourierId’ is probably not passed in editAction')
                }
                requestBody.currentEpakaCurierId = epakaCurrentCourierId
            }

            return requestBody
        }
        async function fetchCouriers(isPreloaderNeed) {
            const fetchCourierButton = document.getElementsByClassName('delivery-inputs-confirm')[0],
                  parentBlock = document.getElementById('delivery-block');
            templateSubmit.disabled = true
            templateSubmit.classList.add('no-active')
            if(fetchCourierButton) fetchCourierButton.style.display = 'none';
            if(parentBlock)  parentBlock.classList.add(shippingPreloaderClass)
            fetch(adminCouriersControllerUrl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    // 'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                },
                body: JSON.stringify(buildCourierRequestData())
            })
                .then(response => {
                    if (!response.ok) {
                        return response.json()
                            .catch(() => ({}))
                            .then(errData => {
                                throw {
                                    status: response.status,
                                    message: errData.message,
                                    redirectUrl: errData.redirectUrl
                                };
                            });
                    }
                    return response.text();
                })
                .then(html => {
                    courierBlockContent.insertAdjacentHTML('beforeend', html);
                    courierBlock.classList.remove('d-none');
                    initCourierCards();
                })
                .finally(() => {
                    fetchCourierButton.style.display = 'block';
                    if(parentBlock)  parentBlock.classList.remove(shippingPreloaderClass)
                })
                .catch(error => {
                    if (error.status === 401 && error.redirectUrl) {
                        window.location.href = error.redirectUrl;
                    } else if (error.status === 404) {
                        showAlert('delivery-block', error.message);
                    } else {
                        showAlert('epaka-module', error.message || error);
                    }
                });
        }
        function initCourierCards() {
            const courierCards = document.querySelectorAll('.courier-card');
            function getRequestDataForAdditionalCourierSettingsAndPriceToFrontend (card) {
                const deliveryParcelTypeInputs = document.querySelectorAll('#delivery-block input, #delivery-block [data-api-select-name="packageType"], #delivery-block [data-api-select-name="senderCountry"], #delivery-block [data-api-select-name="receiverCountry"]'),
                    choiceCourier = card.closest('.courier-card'),
                    choiceCourierId = choiceCourier.getAttribute('data-api-courier-id'),
                    choiceCourierName = choiceCourier.getAttribute('data-api-courier-name'),
                    choiceCourierPrice = choiceCourier.getAttribute('data-api-courier-price');
                let   shippingType = null,
                    senderCountry = null,
                    receiverCountry = null;
                deliveryParcelTypeInputs.forEach(function(elem) {
                    if (elem.type === 'radio') {
                        if (elem.checked) {
                            shippingType = elem.value.toLowerCase();
                        }
                    } else if(elem.tagName.toLowerCase() === 'select') {
                        switch (true) {
                            case elem.getAttribute('data-api-select-name') === 'senderCountry': {
                                senderCountry = elem.value
                                break;
                            }
                            case elem.getAttribute('data-api-select-name') === 'receiverCountry': {
                                receiverCountry = elem.value
                                break;
                            }
                        }
                    }
                });
                return { choiceCourierId,choiceCourierName,choiceCourierPrice,shippingType,senderCountry,receiverCountry };
            }
            if (isEditActionPage) {
                let selectedCourierCard = [...courierCards].filter(courierCard => courierCard.classList.contains('active'))[0];
                if( typeof selectedCourierCard == 'undefined') {
                    selectedCourierCard = [...courierCards][0]
                }
                const requestData = getRequestDataForAdditionalCourierSettingsAndPriceToFrontend(selectedCourierCard);
                fetchAdditionalCourierSettings(requestData.choiceCourierId, requestData.choiceCourierName, requestData.receiverCountry, requestData.senderCountry, requestData.shippingType, epakaCarrierId);
                fetchPriceToFrontend(requestData.choiceCourierName, requestData.choiceCourierPrice, epakaCarrierId);
            }
            courierCards.forEach(card => {
                const radio = card.querySelector('input[type="radio"]');
                if (radio.checked) {
                    templateSubmit.disabled = false
                    templateSubmit.classList.remove('no-active')
                    card.classList.add('active');
                }
                card.addEventListener('click', function(e) {
                    const radio = this.querySelector('input[type="radio"]');
                    if (e.target.type !== 'radio' && !e.target.classList.contains('form-check-label')) {
                        courierCards.forEach(c => c.classList.remove('active'));
                        radio.checked = true;
                        this.classList.add('active');
                        templateSubmit.disabled = false
                        templateSubmit.classList.remove('no-active')
                        radio.dispatchEvent(new Event('change'));
                        hiderAndClearAdditionalCourierContent();
                        hiderAndClearPriceToFrontendContent();
                        const requestData = getRequestDataForAdditionalCourierSettingsAndPriceToFrontend(card);
                        fetchAdditionalCourierSettings(requestData.choiceCourierId, requestData.choiceCourierName, requestData.receiverCountry, requestData.senderCountry, requestData.shippingType);
                        fetchPriceToFrontend(requestData.choiceCourierName, requestData.choiceCourierPrice);
                    }
                });
                const radioButton = card.querySelector('input[type="radio"]');
                radioButton.addEventListener('change', function() {
                    courierCards.forEach(c => c.classList.remove('active'));
                    if (this.checked) {
                        card.classList.add('active');
                    }
                });
            });
        }

        let additionalCourierInputListeners = [];
        let activeFields = new Set();
        let blockedFields = new Set();
        let fieldPrices = new Map();
        function getFrontendPrice() {
            return document.querySelector('#price-for-frontend');
        }
        function calculateTotalPrice() {
            let totalPrice = 0;
            const servicesOptions = additionalCourierSettingsBlockContent.querySelector('.services-options');
            const serviceOptions = servicesOptions.getElementsByClassName('service-option');

            Array.from(serviceOptions).forEach((option, index) => {
                const checkbox = option.querySelector('input[type="checkbox"]');
                if (checkbox && checkbox.checked) {
                    const basePrice = parseFloat(checkbox.getAttribute('data-api-price')) || 0;
                    totalPrice += basePrice;

                    const apiName = checkbox.getAttribute('data-api-name');
                    if (fieldPrices.has(apiName)) {
                        totalPrice += fieldPrices.get(apiName);
                    }
                }
            });

            return totalPrice;
        }
        async function fetchInsurancePrice(courierId, maxWeight, senderCountry, receiverCountry, declaredValue) {
            try {
                const response = await fetch(adminInsuranceRecalculateUrl, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        courierId,
                        declaredValue,
                        maxWeight,
                        receiverCountry,
                        senderCountry
                    })
                });
                if (!response.ok) {
                    const errData = await response.json().catch(() => ({}));
                    let err = new Error(`HTTP error! Status: ${response.status}`);
                    err.status = response.status;
                    err.message = errData.message;
                    err.redirectUrl = errData.redirectUrl;
                    throw err;
                }
                const data = await response.json();
                return data.price || 0;
            } catch (error) {
                if (error.status === 401 && error.redirectUrl) {
                    window.location.href = error.redirectUrl;

                } else {
                    console.error('Failed to fetch insurance price:', error);
                    showAlert('courier-settings-block');
                    return 0;
                }
            }
        }
        function buildInsuranceRecalculateRequestBody(insuranceInput) {
            const courierRequestData = buildCourierRequestData(),
                maxWeight = courierRequestData.packages[0].width,
                senderCountry = courierRequestData.senderCountry,
                receiverCountry = courierRequestData.receiverCountry,
                declaredValue = insuranceInput.value;
            let   courierId = null;
            [...courierBlockContent.children].forEach(function (courier) {
                if(courier.classList.contains('active')) courierId = courier.getAttribute('data-api-courier-id');
            });

            return { courierId, maxWeight, senderCountry, receiverCountry, declaredValue };
        }
        async function fetchCodPrice(courierId, amount) {
            try {
                const response = await fetch(adminCodRecalculateUrl, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        courierId,
                        amount,
                    })
                });

                if (!response.ok) {
                    const errData = await response.json().catch(() => ({}));
                    let err = new Error(`HTTP error! Status: ${response.status}`);
                    err.status = response.status;
                    err.message = errData.message;
                    err.redirectUrl = errData.redirectUrl;
                    throw err;
                }
                const data = await response.json();
                return data.price || 0;
            } catch (error) {
                if (error.status === 401 && error.redirectUrl) {
                    window.location.href = error.redirectUrl;

                } else {
                    console.error('Failed to fetch COD price:', error);
                    showAlert('courier-settings-block', error.message);
                    return 0;
                }
            }
        }
        function buildCodRecalculateRequestBody(input) {
            let courierId = null;
            [...courierBlockContent.children].forEach(function (courier) {
                if(courier.classList.contains('active')) courierId = courier.getAttribute('data-api-courier-id');
            });
            return {
                courierId,
                codAmount: input.value
            };
        }
        async function initializeCheckboxBlockingState() {
            const frontendPriceElement = getFrontendPrice(),
                currentCourier = [...courierBlockContent.children].filter(courierBlock => courierBlock.classList.contains('active'))[0],
                basePrice = parseFloat(currentCourier.getAttribute('data-api-courier-price')),
                inputs = additionalCourierSettingsBlockContent.querySelectorAll('input, select'),
                activeCheckboxes = [...inputs].filter(input => input.type === 'checkbox' && input.checked);
            let totalAdditionalPrice = 0;
            frontendPriceElement.setAttribute('data-base-price', basePrice);
            frontendPriceElement.innerText = basePrice;
            const pricePromises = [];
            activeCheckboxes.forEach(checkbox => {
                const fieldsToBlock = checkbox.getAttribute('data-non-connecting')?.split(',') || [];
                fieldsToBlock.forEach(field => blockedFields.add(field.trim()));
                const apiName = checkbox.getAttribute('data-api-name');
                activeFields.add(apiName);
                const price = parseFloat(checkbox.getAttribute('data-api-price')) || 0;
                totalAdditionalPrice += price;
                const parentOption = checkbox.closest('.service-option');
                const nextOption = parentOption.nextElementSibling;
                if (nextOption?.classList.contains('child')) {
                    nextOption.style.display = 'block';
                    const input = nextOption.querySelector('input[type="text"]');
                    if (input?.value) {
                        if (apiName === 'insurance') {
                            const requestData = buildInsuranceRecalculateRequestBody(input);
                            pricePromises.push(
                                fetchInsurancePrice(
                                    requestData.courierId,
                                    requestData.maxWeight,
                                    requestData.senderCountry,
                                    requestData.receiverCountry,
                                    requestData.declaredValue
                                ).then(price => ({ apiName, price }))
                            );
                        } else if (apiName === 'cod') {
                            const requestData = buildCodRecalculateRequestBody(input);
                            pricePromises.push(
                                fetchCodPrice(
                                    requestData.courierId,
                                    requestData.codAmount
                                ).then(price => ({ apiName, price }))
                            );
                        }
                    }
                }
            });
            if (pricePromises.length > 0) {
                const results = await Promise.all(pricePromises);
                results.forEach(({ apiName, price }) => {
                    fieldPrices.set(apiName, price);
                    totalAdditionalPrice += price;
                });
            }
            [...inputs].forEach(input => {
                if (input.type === 'checkbox') {
                    const fieldName = input.getAttribute('data-api-name');
                    if (blockedFields.has(fieldName)) {
                        input.disabled = true;
                    }
                }
            });
            addAdditionalCourierSettingsBlockInputEventListeners();
            frontendPriceElement.innerText = (basePrice + totalAdditionalPrice).toFixed(2);
        }
        function addAdditionalCourierSettingsBlockInputEventListeners() {
            const inputs = additionalCourierSettingsBlockContent.querySelectorAll('input, select');
            let previousTotal = 0;
            inputs.forEach(input => {
                function debounce(func, wait) {
                    let timeout;
                    return function executedFunction(...args) {
                        const later = () => {
                            clearTimeout(timeout);
                            func(...args);
                        };
                        clearTimeout(timeout);
                        timeout = setTimeout(later, wait);
                    };
                }
                const handleAmountInput = (e) => {
                    const input = e.target;
                    const dataName = input.getAttribute('data-name');
                    const value = parseFloat(input.value) || 0;
                    const parentCheckbox = Array.from(inputs).find(inp =>
                        inp.type === 'checkbox' && inp.getAttribute('data-api-name') === dataName
                    );
                    if (parentCheckbox && parentCheckbox.checked) {
                        if (fieldPrices.has(dataName)) {
                            fieldPrices.delete(dataName);
                        }
                        const tempTotal = calculateTotalPrice();
                        const frontendPriceElement = getFrontendPrice();
                        if (frontendPriceElement) {
                            const baseFrontendPrice = parseFloat(frontendPriceElement.getAttribute('data-base-price') || frontendPriceElement.textContent) || 0;
                            frontendPriceElement.innerText = (baseFrontendPrice + tempTotal).toFixed(2);
                        }
                        debouncedFetchPrice(value, dataName);
                    }
                };
                const debouncedFetchPrice = debounce(async (value, dataName) => {
                    if (!['insurance', 'cod'].includes(dataName)) {
                        alert('Błąd: To pole nie jest poprawnym typem. Prawidłowe obliczenie wartości nie będzie możliwe.');
                        return;
                    }
                    let requestData;
                    if (dataName === 'insurance') {
                        requestData = buildInsuranceRecalculateRequestBody(input);
                    } else if (dataName === 'cod') {
                        requestData = buildCodRecalculateRequestBody(input);
                    }
                    let newPrice = 0;
                    if (dataName === 'insurance') {
                        newPrice = await fetchInsurancePrice(
                            requestData.courierId,
                            requestData.maxWeight,
                            requestData.senderCountry,
                            requestData.receiverCountry,
                            requestData.declaredValue
                        );
                    } else if (dataName === 'cod') {
                        newPrice = await fetchCodPrice(
                            requestData.courierId,
                            requestData.codAmount
                        );
                    }
                    fieldPrices.set(dataName, newPrice);
                    const newTotal = calculateTotalPrice();
                    const frontendPriceElement = getFrontendPrice();
                    if (frontendPriceElement) {
                        const baseFrontendPrice = parseFloat(frontendPriceElement.getAttribute('data-base-price') || frontendPriceElement.textContent) || 0;
                        frontendPriceElement.innerText = (baseFrontendPrice + newTotal).toFixed(2);
                    }
                }, 2000);
                function handleChildFieldVisibilityAndPrice(currentFieldName, frontendPriceElement) {
                    const nextElement = input.closest('.service-option').nextElementSibling;
                    if (nextElement && nextElement.classList.contains('child')) {
                        const childInput = nextElement.querySelector('input[type="text"]');
                        if (input.checked) {
                            nextElement.style.display = 'block';
                        } else {
                            nextElement.style.display = 'none';
                            if (childInput) {
                                const priceToRemove = fieldPrices.get(currentFieldName) || 0;
                                childInput.value = '';
                                fieldPrices.delete(currentFieldName);
                                if (frontendPriceElement) {
                                    const baseFrontendPrice = parseFloat(frontendPriceElement.getAttribute('data-base-price')) || 0;
                                    frontendPriceElement.innerText = (baseFrontendPrice + calculateTotalPrice()).toFixed(2);
                                }
                            }
                        }
                    }
                }
                const handleConflictingFieldsState = (e) => {
                    const frontendPriceElement = getFrontendPrice(),
                        courierAdditionalFields = additionalCourierSettingsBlockContent.children[0].children,
                        currentFieldName = input.getAttribute('data-api-name');

                    handleChildFieldVisibilityAndPrice(currentFieldName, frontendPriceElement)
                    if (input.checked) {
                        activeFields.add(currentFieldName);
                        const fieldsToBlock = input.getAttribute('data-non-connecting')?.split(',') || [];
                        fieldsToBlock.forEach(field => blockedFields.add(field.trim()));
                    } else {
                        activeFields.delete(currentFieldName);
                        blockedFields.clear();
                        activeFields.forEach(activeName => {
                            const activeInput = [...inputs].find(inp =>
                                inp.getAttribute('data-api-name') === activeName
                            );
                            const blockList = activeInput.getAttribute('data-non-connecting')?.split(',') || [];
                            blockList.forEach(field => blockedFields.add(field.trim()));
                        });
                        if (fieldPrices.has(currentFieldName)) {
                            fieldPrices.delete(currentFieldName);
                        }
                    }
                    [...courierAdditionalFields].forEach(field => {
                        const fieldInput = field.getElementsByTagName('input')[0];
                        if (fieldInput) {
                            fieldInput.removeAttribute('disabled');
                        }
                    });
                    [...courierAdditionalFields].forEach(field => {
                        const fieldInput = field.getElementsByTagName('input')[0];
                        if (fieldInput) {
                            const fieldName = fieldInput.getAttribute('data-api-name');
                            if (blockedFields.has(fieldName)) {
                                fieldInput.disabled = true;
                                if (fieldInput.checked) {
                                    fieldInput.checked = false;
                                    fieldInput.dispatchEvent(new Event('input'));
                                }
                            }
                        }
                    });
                    const newAdditionalPrice = calculateTotalPrice();
                    previousTotal = newAdditionalPrice;
                    if (frontendPriceElement) {
                        const baseFrontendPrice = parseFloat(frontendPriceElement.getAttribute('data-base-price') || frontendPriceElement.textContent) || 0,
                            newTotalPrice = baseFrontendPrice + newAdditionalPrice;
                        if (!frontendPriceElement.hasAttribute('data-base-price')) {
                            frontendPriceElement.setAttribute('data-base-price', baseFrontendPrice);
                        }
                        frontendPriceElement.innerText = newTotalPrice.toFixed(2);
                    }
                };
                if (input.type === 'checkbox') {
                    input.addEventListener('change', handleConflictingFieldsState);
                } else if (input.type === 'text' && input.closest('.amount-field')) {
                    input.addEventListener('input', handleAmountInput);
                }

                additionalCourierInputListeners.push({
                    element: input,
                    type: input.type === 'checkbox' ? 'change' : 'input',
                    handler: input.type === 'checkbox' ? handleConflictingFieldsState : handleAmountInput
                });
            });
        }
        function fetchAdditionalCourierSettings(courierId, courierName, receiverCountry, senderCountry, shippingType, psEpakaCarrierId = null, receiverPostCode = null, senderPostCode = null) {
            const parentBlock = document.getElementById('courier-block');
            if(parentBlock) {
                parentBlock.classList.add(shippingPreloaderClass)
            }
            fetch(adminAdditionalCourierSettingsControllerUrl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    courierId: courierId,
                    courierName: courierName,
                    receiverCountry: receiverCountry,
                    senderCountry: senderCountry,
                    shippingType: shippingType,
                    psEpakaCarrierId: psEpakaCarrierId,
                    receiverPostCode: receiverPostCode,
                    senderPostCode: senderPostCode
                })
            })
                .then(response => {
                    if (!response.ok) {
                        return response.json()
                            .then(errData => {
                                let err = new Error(`HTTP error! Status: ${response.status}`);
                                err.status = response.status;
                                err.message = errData.message || "Wystąpił błąd";
                                err.redirectUrl = errData.redirectUrl;
                                throw err;
                            })
                            .catch(() => {
                                let err = new Error(`HTTP error! Status: ${response.status}`);
                                err.status = response.status;
                                throw err;
                            });
                    }
                    return response.text();
                })
                .then(html => {
                    additionalCourierSettingsBlockContent.insertAdjacentHTML('beforeend', html);
                    additionalCourierSettingsBlock.classList.remove('d-none');
                    activeFields.clear();
                    blockedFields.clear();
                    addAdditionalCourierSettingsBlockInputEventListeners();
                })
                .finally(() => {
                    if(parentBlock) {
                        parentBlock.classList.remove(shippingPreloaderClass)
                    }
                })
                .catch(error => {
                    if (error.status === 401 && error.redirectUrl) {
                        window.location.href = error.redirectUrl;

                    } else {
                        console.error('Failed to fetch additional settings:', error);
                        showAlert('courier-block');
                    }
                });
        }
        function fetchPriceToFrontend(courierName, courierPrice, epakaCarrierId= null) {
            const shippingContentWrapper = document.querySelector('.shipping-content-wrapper');
            priceToFrontendWrapperName.innerHTML = courierName;
            if(epakaCarrierId) {
                fetch(adminPriceToFrontendControllerUrl, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        epakaCarrierId: epakaCarrierId
                    })
                })
                    .then(response => {
                        if (!response.ok) {
                            return response.json()
                                .then(errData => {
                                    let err = new Error(`HTTP error! Status: ${response.status}`);
                                    err.status = response.status;
                                    err.message = errData.message || "Wystąpił błąd";
                                    err.redirectUrl = errData.redirectUrl;
                                    throw err;
                                })
                                .catch(() => {
                                    let err = new Error(`HTTP error! Status: ${response.status}`);
                                    err.status = response.status;
                                    throw err;
                                });
                        }
                        return response.text();
                    })
                    .then(html => {
                        priceToFrontendBlockContent.insertAdjacentHTML('beforeend', html);
                        const frontendPrice = getFrontendPrice();
                        frontendPrice.innerText = courierPrice;
                        priceToFrontendBlock.classList.remove('d-none');
                        if (isEditActionPage) {
                            initializeCheckboxBlockingState();
                        }
                    })
                    .catch(error => {
                        if (error.status === 401 && error.redirectUrl) {
                            window.location.href = error.redirectUrl;

                        } else {
                            console.error('Failed to fetch price to frontend:', error);
                            showAlert('courier-block');
                        }
                    });
            } else {
                fetch(adminPriceToFrontendControllerUrl)
                    .then(response => {
                        if (!response.ok) throw new Error(`HTTP error! Status: ${response.status}`);
                        return response.text();
                    })
                    .then(html => {
                        priceToFrontendBlockContent.insertAdjacentHTML('beforeend', html);
                        const frontendPrice = getFrontendPrice();
                        frontendPrice.innerText = courierPrice;
                        priceToFrontendBlock.classList.remove('d-none');
                        if (isEditActionPage) {
                            initializeCheckboxBlockingState();
                        }

                        if(shippingContentWrapper) {
                            shippingContentWrapper.classList.remove('load')
                        }
                    })
                    .catch(error => {
                        console.error('Failed to fetch price to frontend:', error);
                        showAlert('courier-block');
                    });
            }
        }
        function hiderAndClearCourierContent() {
            courierBlockContent.innerHTML = '';
            courierBlock.classList.add('d-none');
        }
        function hiderAndClearAdditionalCourierContent() {
            additionalCourierInputListeners.forEach(({ element, type, handler }) => {
                element.removeEventListener(type, handler);
            });
            additionalCourierInputListeners = [];
            activeFields.clear();
            blockedFields.clear();
            additionalCourierSettingsBlockContent.innerHTML = '';
            additionalCourierSettingsBlock.classList.add('d-none');
        }
        function hiderAndClearPriceToFrontendContent() {
            priceToFrontendBlockContent.innerHTML = '';
            priceToFrontendBlock.classList.add('d-none');
        }
    }
    const ordersTable = document.getElementById('ordersTable');
    if(ordersTable) {
        const ordersTableRows = ordersTable.querySelectorAll('tbody tr td[data-type="arrow-button"] > .arrow-button');
        [...ordersTableRows].forEach(function (arrowRowButton) {
            arrowRowButton.addEventListener('click', function (){
                this.setAttribute('disabled', 'true');
                const orderRow = arrowRowButton.closest('tr'),
                    arrowIcon = orderRow.getElementsByClassName('arrow-icon')[0],
                    preloaderIcon = orderRow.getElementsByClassName('preloader-icon')[0],
                    orderId = this.parentElement.getAttribute('data-module-order-id');
                this.classList.toggle('active')
                this.closest('tr').classList.toggle('active')
                arrowIcon.classList.add('d-none')
                preloaderIcon.classList.remove('d-none')
                if(this.classList.contains('active')) {
                    fetch(orderAdditionalInfoUrl, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({
                            'epakaOderId':+orderId,
                            'isShipmentPage': !!isShipmentPage
                        })
                    })
                        .then(response => {
                            if (!response.ok) {
                                return response.json().then(errData => {
                                    let err = new Error(`HTTP error! Status: ${response.status}`);
                                    err.status = response.status;
                                    err.message = errData.message || "Wystąpił błąd";
                                    err.redirectUrl = errData.redirectUrl;
                                    showAlert('epaka-module', errData.message)
                                    arrowIcon.classList.remove('d-none')
                                    preloaderIcon.classList.add('d-none')
                                    this.classList.remove('active')
                                    this.closest('tr').classList.remove('active')
                                    arrowRowButton.removeAttribute('disabled');
                                    console.error(errData.message)
                                    throw err;
                                });
                            }
                            return response.json();
                        })
                        .then(res => {
                            const orderAdditionalBlock = document.createElement('tr'),
                                orderRowActionButtons = document.createElement('tr');
                            orderAdditionalBlock.classList.add('order-additional-block');
                            orderRowActionButtons.classList.add('order-buttons-block');
                            orderAdditionalBlock.setAttribute('data-module-order-id', arrowRowButton.closest('td').getAttribute('data-module-order-id'));
                            orderRowActionButtons.setAttribute('data-module-order-id', arrowRowButton.closest('td').getAttribute('data-module-order-id'));
                            if (res.isShipmentPage) {
                                orderAdditionalBlock.innerHTML = `
                                    <td colspan="12" class="order-additional-info-parent-block">
                                      <div class="order-additional-info-block">
                                        <div class="customer-info">
                                          <h5>Dane zamawiającego</h5>
                                          <p>${res.customer.firstName} ${res.customer.lastName}</p>
                                          <p>${res.customer.city}</p>
                                          <p>tel. ${res.customer.phone}</p>
                                          <p>${res.customer.email}</p>
                                          <br>
                                          <br>
                                          <h5>Dane do faktury</h5>
                                          <p>Firma: ${res.invoiceData.company || '—'}</p>
                                          <p>${res.invoiceData.address}</p>
                                          <p>${res.invoiceData.postCode}, ${res.invoiceData.city}, ${res.recipient.country}</p>
                                          <p>NIP: ${res.invoiceData.vatNumber || '—'}</p>
                                        </div>
                                        <div class="recipient-info">
                                          <h5>Dane odbiorcy</h5>
                                          <p>${res.recipient.firstName} ${res.recipient.lastName}</p>
                                          <p>${res.recipient.address1}</p>
                                          <p>${res.recipient.postCode}, ${res.recipient.city}, ${res.recipient.country}</p>
                                          <p>tel. ${res.recipient.phone || '—'}</p>
                                          <p>${res.recipient.email || '—'}</p>
                                          ${ res.pointTrackingCode ? `
                                            <br>
                                            <br>
                                            <h5>Punkt odbioru</h5>
                                            <p>${res.pointTrackingCode}</p>
                                           ` : '' }
                                        </div>
                                        <div class="order-additional-options">
                                          <h5>Dodatkowe usługi</h5>
                                          <div>
                                            ${res.orderAdditionalOptions.map(option => `
                                              <div class="md-checkbox mb-2">
                                                <label>
                                                  <input type="checkbox" name="checkbox[]" checked disabled />
                                                  <i class="md-checkbox-control"></i>
                                                  ${option.label}
                                                </label>
                                              </div>
                                            `).join('')}
                                          </div>
                                        </div>
                                        <div class="carrier-comment">
                                          <strong>Dodatkowe informacje:</strong> 
                                          <br>
                                          <p>${res.carrierAdditionalMessage}</p>
                                          <br>
                                          <br>
                                          <h5>Kwota zamówienia</h5>
                                          <p>${res.totalPaidTaxIncl}</p>
                                          ${ res.isHasInvoice ? `<span class="status-badge purple mt-1 d-inline-block">Faktura</span>` : '' }
                                        </div>
                                         <div class="divider"></div>
                                        <div class="sender-info" style="grid-column: 2 / 3;">
                                          <h5>Dane nadawcy</h5>
                                          ${ res.sender.companyName ? `<p>${res.sender.companyName}</p>` : '' }
                                          ${ res.sender.firstName ? `<p>${res.sender.firstName} ${res.sender.lastName}</p>` : '' }
                                          ${ res.sender.street ? `<p>${res.sender.street}</p>` : '' }
                                          <p>
                                            ${ res.sender.postCode ? `${res.sender.postCode}` : '' }
                                            ${ res.sender.city ? `${res.sender.city},` : '' }
                                            ${ res.sender.country ? `${res.sender.country}` : '' }
                                          </p>
                                          ${ res.sender.phone ? `<p>tel. ${res.sender.phone}</p>` : '' }
                                          <br>
                                        </div>
                                          ${!isShipmentPageDeleted ? `
                                             <div class="sender-info">
                                              <h5>Dokumenty</h5>
                                              <a href="${res.downloadProtocolUrl}"  target="_blank" class="btn btn-outline-secondary btn-sm mb-2">Drukuj protokół nadania (PDF)</a><br>
                                              <a href="${res.downloadLabelUrl}"  target="_blank"  class="btn btn-outline-secondary btn-sm">Drukuj etykietę (PDF)</a>
                                            </div>
                                           ` : '' }
                                        <div class="parcel-info">
                                          <h5>Przesyłka</h5>
                                          ${ res.templateName ? `<p>${res.templateName}</p>` : '' }<br>
                                          ${ res.shipmentType ? `<p>Rodzaj przesyłki: ${res.shipmentType}</p>` : '' }<br>
                                          ${ res.totalLength ? `<p>Długość: ${res.totalLength} cm</p>` : '' }
                                          ${ res.totalWidth ? `<p>Szerokość: ${res.totalWidth} cm</p>` : '' }
                                          ${ res.totalHeight ? `<p>Wysokość: ${res.totalHeight} cm</p>` : '' }<br>
                                          ${ res.totalOrderWeight ? `<p>Waga: ${res.totalOrderWeight} kg</p>` : '' }
                                        </div>
                                      </div>
                                      
                                    </td>
                                  `;
                            } else {
                                orderAdditionalBlock.innerHTML = `
                                    <td colspan="12" class="order-additional-info-parent-block">
                                      <div class="order-additional-info-block">
                                        <div class="customer-info">
                                          <h5>Dane zamawiającego</h5>
                                          <p>${res.customer.firstName} ${res.customer.lastName}</p>
                                          <p>${res.customer.city}</p>
                                          <p>tel. ${res.customer.phone}</p>
                                          <p>${res.customer.email}</p>
                                          <br>
                                          <br>
                                          <h5>Dane do faktury</h5>
                                          <p>Firma: ${res.invoiceData.company || '—'}</p>
                                          <p>${res.invoiceData.address}</p>
                                          <p>${res.invoiceData.postCode}, ${res.invoiceData.city}, ${res.recipient.country}</p>
                                          <p>NIP: ${res.invoiceData.vatNumber || '—'}</p>
                                        </div>
                                        <div class="recipient-info">
                                          <h5>Dane odbiorcy</h5>
                                          <p>${res.recipient.firstName} ${res.recipient.lastName}</p>
                                          <p>${res.recipient.address1}</p>
                                          <p>${res.recipient.postCode}, ${res.recipient.city}, ${res.recipient.country}</p>
                                          <p>tel. ${res.recipient.phone || '—'}</p>
                                          <p>${res.recipient.email || '—'}</p>
                                          ${ res.pointTrackingCode ? `
                                            <br>
                                            <br>
                                            <h5>Punkt odbioru</h5>
                                            <p>${res.pointTrackingCode}</p>
                                           ` : '' }
                                        </div>
                                        <div class="order-additional-options">
                                          <h5>Dodatkowe usługi</h5>
                                          <div>
                                            ${res.orderAdditionalOptions.map(option => `
                                              <div class="md-checkbox mb-2">
                                                <label>
                                                  <input type="checkbox" name="checkbox[]" checked disabled />
                                                  <i class="md-checkbox-control"></i>
                                                  ${option.label}
                                                </label>
                                              </div>
                                            `).join('')}
                                          </div>
                                        </div>
                                        <p class="carrier-comment">
                                          <strong>Dodatkowe informacje:</strong> ${res.carrierAdditionalMessage}
                                        </p>
                                      </div>
                                    </td>
                                  `;
                            }
                            switch (true) {
                                case !!isShipmentPageDeleted: {
                                    orderRowActionButtons.innerHTML = `
                                    <td colspan="10" class="order-action-buttons p-0"></td>
                                    `
                                    break;
                                }
                                case !!isShipmentPage: {
                                    orderRowActionButtons.innerHTML = `
                                    <td colspan="10" class="order-action-buttons p-0">
                                        <div>
                                             <a style="margin-right: auto" href="${res.deleteShipmentUrl}" class="btn btn-danger  btn-sm">Usuń przesyłkę</a>
                                        </div>
                                    </td>
                                    `
                                    break;
                                }
                                case res.isPsCanceled: {
                                    orderRowActionButtons.innerHTML = `
                                    <td colspan="12" class="order-action-buttons p-0">
                                        <div>
                                            <a href="${res.orderCoreEditUrl}" target="_blank"  class="btn btn-primary btn-sm">Edytuj</a>
                                        </div>
                                    </td>
                                `;
                                    break;
                                }
                                case res.isCreated: {
                                    orderRowActionButtons.innerHTML = `
                                    <td colspan="12" class="order-action-buttons p-0">
                                        <div>
                                            <button onclick="window.location.href='${res.deleteOrderUrl}'"  class="btn btn-danger btn-sm">Usuń zamówienie</button>
                                            <a href="${res.orderCoreEditUrl}" target="_blank"  class="btn btn-primary btn-sm">Edytuj</a>
                                        </div>
                                    </td>
                                `;
                                    break;
                                }
                                case !res.isCreated: {
                                    orderRowActionButtons.innerHTML = `
                                    <td colspan="12" class="order-action-buttons p-0">
                                        <div>
                                            <button onclick="window.location.href='${res.deleteOrderUrl}'"  class="btn btn-danger btn-sm">Usuń zamówienie</button>
                                            <a href="${res.orderCoreEditUrl}" target="_blank"  class="btn btn-primary btn-sm">Edytuj</a>
                                            <button class="btn btn-default btn-sm" data-action="generate">Wygeneruj przesyłkę</button>     
                                        </div>
                                    </td>
                                `;
                                    break;
                                }
                            }
                            orderRow.after(orderAdditionalBlock);
                            orderAdditionalBlock.after(orderRowActionButtons);
                            arrowIcon.classList.remove('d-none')
                            preloaderIcon.classList.add('d-none')
                            arrowRowButton.removeAttribute('disabled');
                            createEpakaOrder(orderRowActionButtons);
                            orderRow.after(orderAdditionalBlock);
                            orderAdditionalBlock.after(orderRowActionButtons);
                            orderRow.after(orderAdditionalBlock);
                            orderAdditionalBlock.after(orderRowActionButtons);
                        })
                        .catch(error => {
                            if (error.status === 401 && error.redirectUrl) {
                                window.location.href = error.redirectUrl;

                            }
                        });
                } else {
                    if(orderRow.nextElementSibling.classList.contains('order-additional-block'))  orderRow.nextElementSibling.remove()
                    if(orderRow.nextElementSibling.classList.contains('order-buttons-block')) orderRow.nextElementSibling.remove()
                    arrowIcon.classList.remove('d-none')
                    preloaderIcon.classList.add('d-none')
                    arrowRowButton.removeAttribute('disabled');
                }
            })
        });
    }
    function createEpakaOrder(orderRowActionButtons) {
        const createOrderButton = orderRowActionButtons.querySelector('[data-action="generate"]');
        if(createOrderButton) {
            createOrderButton.addEventListener('click', function() {
                const orderId = createOrderButton.closest('tr').getAttribute('data-module-order-id'),
                      parentBlock = createOrderButton.closest('tr').previousElementSibling;
                this.disabled = true;
                parentBlock.classList.add(orderPreloaderClass)
                fetch(orderApiCreateUrl, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        'epakaOderId': orderId
                    })
                })
                    .then(response => {
                        if (!response.ok) {
                            return response.json().then(errData => {
                                let err = new Error(`HTTP error! Status: ${response.status}`);
                                err.status = response.status;
                                err.message = errData.message || "Wystąpił błąd";
                                err.redirectUrl = errData.redirectUrl;
                                showAlert('epaka-module', errData.message);
                                this.disabled = false;
                                console.error(errData.message);
                                throw err;
                            });
                        }
                        return response.json();
                    })
                    .then(res => {
                        this.remove();
                        showAlert('epaka-module', res.message, 'success');
                        setTimeout(() => {
                            location.reload();
                        }, 3000);
                        return res;
                    })
                    .catch(error => {
                        if (error.status === 401 && error.redirectUrl) {
                            window.location.href = error.redirectUrl;

                        }
                    })
                    .finally(() => {
                        parentBlock.classList.remove(orderPreloaderClass)
                        this.disabled = false;
                    })
            });
        }
    }
    const orderMassForm = document.getElementById('orderMassForm');
    if(orderMassForm) {
        orderMassForm.addEventListener('submit', function (event) {
            const rowIdsToAction = [];
            const orderMassSelect = document.getElementById('order-mass-select');
            const selectedOption = orderMassSelect.value;
            const tableRows = document.querySelectorAll('tbody input[type="checkbox"]');
            tableRows.forEach(row => {
                const rowId = row.closest('.order-row')?.getAttribute('data-row-id');
                if (row.checked && rowId) rowIdsToAction.push(rowId);
            });
            document.getElementById('selected-rows').value = JSON.stringify(rowIdsToAction);
        });
    }
})