<?php

namespace Epaka\Traits;

use Context;

Trait CountryTrait {
    private $countryDataProvider;


    private function getCountries(string $keyType, Context $context): array
    {
        $countryProvider = $this->getCountryDataProvider();
        return array_reduce($countryProvider->getCountries($context->language->id), function ($carry, $country) use ($keyType) {
            $carry[$country[$keyType]] = $country['name'];
            return $carry;
        }, []);
    }
    private function getCountryDataProvider()
    {
        if (!$this->countryDataProvider) {
            $this->countryDataProvider = $this->get('prestashop.adapter.data_provider.country');
        }

        return $this->countryDataProvider;
    }
}