<?php
namespace Epaka\Tests;

class TestOrder
{
    public static function generateOrdersData(int $count = 40): array
    {
        $testOrders = [];
        $carrierNames = ['DHL', 'UPS', 'FedEx', 'Poczta Polska', 'GLS', 'DPD', 'InPost'];
        $templateNames = [
            'Epaka DHL',
            'Epaka UPS',
            'Epaka FedEx',
            'Epaka InPost',
            'Epaka GLS',
            'Epaka DPD'
        ];
        $orderStatuses = [
            1 => ['name' => 'Oczekiwanie na płatność', 'color' => '#4169E1'], // Royal Blue
            2 => ['name' => 'Płatność zaakceptowana', 'color' => '#32CD32'], // Lime Green
            3 => ['name' => 'W trakcie realizacji', 'color' => '#FFA500'], // Orange
            4 => ['name' => 'Wysłane', 'color' => '#1E90FF'], // Dodger Blue
            5 => ['name' => 'Dostarczone', 'color' => '#00FF00'], // Green
            6 => ['name' => 'Anulowane', 'color' => '#FF0000'], // Red
            7 => ['name' => 'Zwrócone', 'color' => '#A9A9A9'], // Dark Gray
            10 => ['name' => 'Oczekiwanie na przelew', 'color' => '#FFD700'] // Gold
        ];
        $productNames = [
            'Testowy produkt',
            'Samsung Galaxy S21',
            'iPhone 14 Pro',
            'ASUS ZenBook',
            'Sony WH-1000XM4',
            'iPad Air',
            'Xiaomi Mi Band 6',
            'Apple Watch Series 7',
            'Logitech MX Keys',
            'Dell UltraSharp Monitor'
        ];
        $epakaProcessStatuses = [null, 0, 1, 2, 3, 4, 5];
        $epakaApiIds = ['-', 'EP000001', 'EP000002', 'EP000003', 'EP000004', 'EP000005', null];
        $firstNames = ['Andrzej', 'Piotr', 'Jan', 'Marek', 'Tomasz', 'Krzysztof', 'Michał', 'Anna', 'Maria', 'Katarzyna'];
        $lastNames = ['Kowalski', 'Nowak', 'Wiśniewski', 'Wójcik', 'Kowalczyk', 'Lewandowski', 'Kamiński', 'Zieliński', 'Szymański', 'Shlyaga'];
        $companies = ['', 'Firma ABC', 'XYZ Sp. z o.o.', 'Tech Solutions', 'Biuro Handlowe', null];
        $streets = ['ul. gen. Klemensa Stanisława Rudnickiego', 'ul. Marszałkowska', 'ul. Krakowska', 'ul. Warszawska', 'ul. Mickiewicza', 'ul. Słowackiego', 'ul. Kopernika'];
        $cities = ['Warszawa', 'Kraków', 'Wrocław', 'Poznań', 'Gdańsk', 'Szczecin', 'Łódź', 'Lublin'];
        $postcodes = ['01-858', '00-001', '30-001', '50-001', '60-001', '80-001', '70-001', '20-001'];
        $emailDomains = ['gmail.com', 'wp.pl', 'onet.pl', 'interia.pl', 'o2.pl', 'yahoo.com'];
        for ($i = 1; $i <= $count; $i++) {
            $statusIndex = array_rand($epakaProcessStatuses);
            $status = $epakaProcessStatuses[$statusIndex];
            $psStatusKey = array_rand($orderStatuses);
            $psStatus = $orderStatuses[$psStatusKey];
            $isDeleted = (rand(0, 10) > 8);
            $statusInText = null;
            $statusBadgeName = null;
            if (!$isDeleted && $status !== null) {
                switch ($status) {
                    case 0:
                        $statusInText = 'Oczekiwanie';
                        $statusBadgeName = 'warning';
                        break;
                    case 1:
                        $statusInText = 'Przetwarzanie';
                        $statusBadgeName = 'info';
                        break;
                    case 2:
                        $statusInText = 'Wysłane';
                        $statusBadgeName = 'primary';
                        break;
                    case 3:
                        $statusInText = 'Dostarczone';
                        $statusBadgeName = 'success';
                        break;
                    case 4:
                        $statusInText = 'Błąd';
                        $statusBadgeName = 'danger';
                        break;
                    case 5:
                        $statusInText = 'Anulowane';
                        $statusBadgeName = 'dark';
                        break;
                }
            }
            $productNamesAndQty = self::generateMultipleProducts($productNames);
            $firstName = $firstNames[array_rand($firstNames)];
            $lastName = $lastNames[array_rand($lastNames)];
            $email = strtolower($firstName . '.' . $lastName . rand(1, 99) . '@' . $emailDomains[array_rand($emailDomains)]);
            $testOrders[] = [
                'id' => (string)$i,
                'epakaApiId' => $epakaApiIds[array_rand($epakaApiIds)],
                'productNamesAndQty' => $productNamesAndQty,
                'totalPaidTaxIncl' => sprintf('%.2f', rand(5000, 50000) / 100),
                'isHasInvoice' => (bool)rand(0, 1),
                'statusInText' => $statusInText,
                'statusBadgeName' => $statusBadgeName,
                'defaultPsCoreStatusLabel' => $psStatus['name'],
                'defaultPsCoreStatusColor' => $psStatus['color'],
                'carrierName' => $carrierNames[array_rand($carrierNames)],
                'templateName' => $templateNames[array_rand($templateNames)],
                'apiParcelNumber' => $epakaApiIds[array_rand($epakaApiIds)],
                'receiver' => [
                    'firstName' => $firstName,
                    'lastName' => $lastName,
                    'company' => $companies[array_rand($companies)],
                    'address1' => $streets[array_rand($streets)] . ' ' . rand(1, 100) . '/' . rand(1, 50),
                    'address2' => rand(0, 1) ? '' : 'Piętro ' . rand(1, 10),
                    'city' => $cities[array_rand($cities)],
                    'state' => rand(0, 1) ? '' : 'Mazowieckie',
                    'postcode' => $postcodes[array_rand($postcodes)],
                    'country' => 'Polska',
                    'phone' => ''.rand(500000000, 899999999),
                    'email' => $email
                ],
                'createdAt' => date('d/m/Y', strtotime('-' . rand(1, 60) . ' days')),
            ];
        }
        return $testOrders;
    }

    private static function generateMultipleProducts(array $productNames): string
    {
        $numberOfProducts = rand(1, 4);
        $productsArray = [];
        $selectedProductIndexes = array_rand($productNames, $numberOfProducts);
        if (!is_array($selectedProductIndexes)) $selectedProductIndexes = [$selectedProductIndexes];
        foreach ($selectedProductIndexes as $index) $productsArray[] = "(".rand(1, 5).") {$productNames[$index]}<br>";
        return rtrim(implode('', $productsArray), '<br>');
    }
}