<?php

namespace Epaka\Service;

use Exception;
use setasign\Fpdi\Tcpdf\Fpdi;

class PdfService
{
    /**
     * @throws Exception
     */
    public static function mergePdfFiles(array $filePaths, string $outputFilename = 'output.pdf', bool $cleanUpFiles = true): bool
    {
        try {
            $pdf = new Fpdi();
            foreach ($filePaths as $file) {
                if (!file_exists($file)) continue;
                $pageCount = $pdf->setSourceFile($file);
                for ($i = 1; $i <= $pageCount; $i++) {
                    $template = $pdf->importPage($i);
                    $size = $pdf->getTemplateSize($template);
                    $pdf->AddPage($size['orientation'], [$size['width'], $size['height']]);
                    $pdf->useTemplate($template);
                }
            }

            if ($pdf->getNumPages() > 0) {
                if ($cleanUpFiles) {
                    foreach ($filePaths as $file) {
                        if (file_exists($file)) unlink($file);
                    }
                }
                $pdf->Output($outputFilename, 'D');
                exit;
            } else {
                throw new Exception('Nie ma stron do scalenia');
            }
        } catch (Exception $e) {
            if ($cleanUpFiles) {
                foreach ($filePaths as $file) {
                    if (file_exists($file)) {
                        unlink($file);
                    }
                }
            }

            throw $e;
        }
    }
}