<?php

namespace Epaka\Service;

class ParcelTypeHardcodedService
{
    private static $packages = [
        0 => [
            "id" => 0,
            "name" => "standardowe",
            "description" => "Przesyłka o kształcie prostopadłościanu, zapakowana w karton.",
            "image" => "https://www.epaka.pl/img/front/package-type-icon-0.png",
            "size" => [
                "length" => null,
                "width" => null,
                "height" => null,
                "weight" => null
            ]
        ],
        1 => [
            "id" => 1,
            "name" => "niestandardowe",
            "description" => "Nieregularne kształty przesyłki inne niż prostopadłościan lub wymagające ręcznego sortowania. W przypadku przewoźnika UPS i DHL z uwagami lub naklejkami typu ostrożnie, nie rzucać, uwaga szkło lub góra/dół.",
            "image" => "https://www.epaka.pl/img/front/package-type-icon-1.png",
            "size" => [
                "length" => null,
                "width" => null,
                "height" => null,
                "weight" => null
            ]
        ]
    ];

    public static function getPackageType(int $id): array
    {
        return self::$packages[$id] ?? [
            "id" => 0,
            "name" => "standardowe",
            "description" => "Przesyłka o kształcie prostopadłościanu, zapakowana w karton.",
            "image" => "https://www.epaka.pl/img/front/package-type-icon-0.png",
            "size" => [
                "length" => null,
                "width" => null,
                "height" => null,
                "weight" => null
            ]
        ];
    }
}