<?php

namespace Epaka\Service;

use Db;
use Epaka\Mapper\CourierStatusMapper;
use Epaka\Mapper\EpakaOrderStatusMapper;
use Exception;
use PrestaShopLogger;

class EpakaOrderStatusUpdateService
{
    /**
     * @throws Exception
     */
    public static function updateStatuses(): void
    {
        $db = Db::getInstance();
        $sql = 'SELECT id, api_order_id FROM ' . _DB_PREFIX_ . 'epaka_parcel WHERE is_deleted = 0 AND api_order_id IS NOT NULL AND (courier_status != ' . CourierStatusMapper::PACKAGE_DELIVERED . ' OR courier_status IS NULL)';
        $token = self::getAccessToken();
        $parcels = $db->executeS($sql);
        if (!$parcels) return;
        foreach ($parcels as $parcel) {
            try {
                $apiData = ApiService::fetchOrderDetails($token, $parcel['api_order_id']);
                $epakaStatus = isset($apiData['orderStatus'])
                    ? EpakaOrderStatusMapper::convertStringStatusToInt($apiData['orderStatus'])
                    : null;
                $courierStatus = isset($apiData['packageStatus'])
                    ? CourierStatusMapper::convertStringStatusToInt($apiData['packageStatus'])
                    : CourierStatusMapper::PACKAGE_NO_SEND;
                    $db->update(
                        'epaka_parcel', [
                        'epaka_status' => $epakaStatus,
                        'courier_status' => $courierStatus
                    ],
                        'id = ' . (int)$parcel['id']
                    );
                } catch (Exception $e) {
                    throw new Exception(
                        $e->getMessage(),
                        $e->getCode()
                    );
            }
        }
    }

    private static function getAccessToken()
    {
        $db = Db::getInstance();
        $sql = "SELECT access_token FROM " . _DB_PREFIX_ . "epaka_auth";
        $result = $db->executeS($sql);
        return $result[0]['access_token'];
    }
}