<?php

namespace Epaka\Service;

use DateTime;
use Doctrine\ORM\EntityManagerInterface;
use Epaka\Entity\EpakaAuth;
use Exception;
use Tools;
use Context;

class AuthGuardService 
{
    /** @var EntityManagerInterface */
    private $em;
    
    /**
     * @param EntityManagerInterface
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    public function isAuthenticated(): bool
    {
        $authRecord = $this->em->getRepository(EpakaAuth::class)->findOneBy([]) ?? null;
        if($authRecord) {
            $now = new DateTime();
            if($authRecord->getExpiresAt()->getTimestamp() >= $now->getTimestamp()) return true;
            try {   
                $authData = ApiService::refreshToken(
                    CryptoService::decrypt($authRecord->getClientId(), '4wHLnV9WVOADoNS'), 
                    CryptoService::decrypt($authRecord->getClientSecret(), '4wHLnV9WVOADoNS'), 
                    $authRecord->getRefreshToken()
                );
                $authRecord->setAccessToken($authData['access_token']);
                $authRecord->setRefreshToken($authData['refresh_token']);
                $expiresTimestamp = time() + $authData['expires_in'];
                $expiresAt = new DateTime("@$expiresTimestamp");
                $authRecord->setExpiresAt($expiresAt);
                $this->em->flush();
            } catch (Exception $e){
                $this->em->remove($authRecord);
                $this->em->flush();
                return false;
            }
        }
       
        if(!$authRecord) return false;

        return true;
    }

    public function getAccessToken(): string
    {
        $authRecord = $this->em->getRepository(EpakaAuth::class)->findOneBy([]);
        return $authRecord->getAccessToken();
    }

    public function getPageUrl(): string
    {
        $authRecord = $this->em->getRepository(EpakaAuth::class)->findOneBy([]) ?? null;
        if($authRecord) {
            $this->em->remove($authRecord);
            $this->em->flush();
        }
        if (version_compare(_PS_VERSION_, '1.7.6.8', '<') || version_compare(_PS_VERSION_, '8.0.0', '>=')) {
            return rtrim(Tools::getHttpHost(true), '/') . '/' . ltrim(Context::getContext()->link->getAdminLink('AdminEpakaAuth', true, []), '/');
        } else {
            return '/' . ltrim(parse_url(Context::getContext()->link->getAdminLink('AdminEpakaAuth', true, []), PHP_URL_PATH), '/') . '?_token=' . Tools::getAdminTokenLite('AdminEpakaAuth');
        }
    }
}