<?php

namespace Epaka\Service;

class ApiFieldLengthService
{
    /**
     * Dynamic method call to retrieve min/max values for different field groups.
     *
     * Usage example:
     * - To get the minimum value of `firstname` in the `receiver` group:
     *   FieldLengthService::receiverFirstnameMin();
     */
    private static function getRules(): array
    {

        return [
            'receiver' => [
                'firstname' => ['min' => 3, 'max' => 50],
                'lastname' => ['min' => 3, 'max' => 100],
                'phone' => ['min' => 9, 'max' => 15],
                'postcode' => ['min' => 1, 'max' => 10],
                'address1' => ['min' => 1, 'max' => 60],
                'address2' => ['min' => 1, 'max' => 7],
                'city' => ['min' => 1, 'max' => 50],
                'company' => ['min' => 4, 'max' => 200],
            ],
            'sender' => [
                'firstname' => ['min' => 2, 'max' => 40],
                'lastname' => ['min' => 2, 'max' => 80],
                'phone' => ['min' => 9, 'max' => 15],
                'postcode' => ['min' => 5, 'max' => 10],
                'address1' => ['min' => 5, 'max' => 60],
                'city' => ['min' => 2, 'max' => 50],
                'company' => ['min' => 4, 'max' => 200],
            ],
            'customer' => [
                'email' => ['min' => 1, 'max' => 100]
            ],
        ];
    }

    public static function getMin(string $group, string $field): ?int
    {
        $rules = self::getRules();
        return $rules[$group][$field]['min'] ?? null;
    }

    public static function getMax(string $group, string $field): ?int
    {
        $rules = self::getRules();
        return $rules[$group][$field]['max'] ?? null;
    }

    public static function __callStatic($name, $arguments)
    {
        if (preg_match('/^([a-z]+)([A-Z][a-zA-Z0-9]*)(Min|Max)$/', $name, $matches)) {
            $group = strtolower($matches[1]);
            $field = lcfirst($matches[2]);
            $type = $matches[3];
            $rules = self::getRules();
            if (!isset($rules[$group][$field])) {
                return null;
            }

            return $type === 'Min' ? self::getMin($group, $field) : self::getMax($group, $field);
        }
        return null;
    }


}
