<?php

namespace Epaka\Mapper;

class ShippingMapper {
    public const PACKAGE_TYPE_ENVELOPE = 'envelop';
    public const PACKAGE_TYPE_PARCEL = 'package';
    public const PACKAGE_TYPE_PALLET = 'pallet';

    public const PARCEL_TYPE_STANDARD = 'standardowe';
    public const PARCEL_TYPE_TYPE_NOT_STANDARD = 'niestandardowe';

    public static function convertShippingTypeToString($type): string
    {
        switch($type) {
            case 0: return self::PACKAGE_TYPE_ENVELOPE;
            case 1: return self::PACKAGE_TYPE_PARCEL;
            case 2: return self::PACKAGE_TYPE_PALLET;
            default: return self::PACKAGE_TYPE_PARCEL;
        }
    }
    public static function convertShippingTypeToHumanString($type): string
    {
        switch ($type) {
            case 0:
                return 'Koperta';
            case 1:
                return 'Paczka';
            case 2:
                return 'Paleta';
        }
    }
    public static function convertParcelTypeToString($type): string
    {
        return $type == 0 ? self::PARCEL_TYPE_STANDARD : self::PARCEL_TYPE_TYPE_NOT_STANDARD;
    }
    public static function convertShippingTypeToInt(string $type): int {
        switch($type) {
            case self::PACKAGE_TYPE_ENVELOPE: return 0;
            case self::PACKAGE_TYPE_PARCEL: return 1;
            case self::PACKAGE_TYPE_PALLET: return 2;
        }
    }
    public static function convertParcelTypeToInt(string $type): int {
        return $type === self::PARCEL_TYPE_STANDARD ? 0 : 1;
    }
}