<?php

namespace Epaka\Mapper;

class PaymentTypeMapper {
    public const BALANCE = 0;
    public const ONLINE_TYPE_TYPE = 1;
    public const CUMULATIVE_PAYMENT_TYPE = 2;
//    public const PAY_ON_DELIVERY_TYPE = 3;

    private const ORDER_STATUSES = [
        self::BALANCE => 'balance',
        self::ONLINE_TYPE_TYPE => 'online_payment',
        self::CUMULATIVE_PAYMENT_TYPE => 'cumulative_payment',
//        self::PAY_ON_DELIVERY_TYPE => 'pay_on_delivery',

    ];
    public const HUMAN_READABLE_STATUSES = [
        self::BALANCE => 'Saldo',
        self::ONLINE_TYPE_TYPE => 'Płatność online (P24, BLIK)',
        self::CUMULATIVE_PAYMENT_TYPE => 'Płatność abonametowa',
//        self::PAY_ON_DELIVERY_TYPE => 'Płatność przy doręczeniu',

    ];

    public static function convertIntToStringStatus(int $status): string
    {
        return self::ORDER_STATUSES[$status];
    }
    public static function convertStringStatusToInt(string $status): int
    {
        $reverseMapping = array_flip(self::ORDER_STATUSES);
        return $reverseMapping[$status];
    }
    public static function convertIntToHumanReadableStatus(int $status): string
    {
        return self::HUMAN_READABLE_STATUSES[$status];
    }
    public static function convertStringToHumanReadableStatus(string $status): string
    {
        $reverseMapping = array_flip(self::ORDER_STATUSES);
        $intStatus = $reverseMapping[$status];
        return self::HUMAN_READABLE_STATUSES[$intStatus];
    }
    private static function getHumanReadableStatuses(): array
    {
        return self::HUMAN_READABLE_STATUSES;
    }
}