<?php

namespace Epaka\Mapper;

class EpakaOrderStatusMapper {
    public const WAITING_FOR_PAYMENT = 0;
    public const IN_PROGRESS = 1;
    public const ENDED = 2;
    public const ERRORS = 3;
    public const CANCELED = 4;
    public const PAID = 5;
    public const UNKNOWN = 6;

    private const ORDER_STATUSES = [
        self::WAITING_FOR_PAYMENT => 'waiting_for_payment',
        self::IN_PROGRESS => 'in_progress',
        self::ENDED => 'ended',
        self::ERRORS => 'errors',
        self::CANCELED => 'canceled',
        self::PAID => 'paid',
    ];
    public const HUMAN_READABLE_STATUSES = [
        self::WAITING_FOR_PAYMENT => 'Oczekuje na zapłatę',
        self::IN_PROGRESS => 'W trakcie',
        self::ENDED => 'Zakończono',
        self::ERRORS => 'Błąd',
        self::CANCELED => 'Anulowane',
        self::PAID => 'Opłacono',
        self::UNKNOWN => 'Nieznany status'
    ];
    private const BADGES = [
        self::WAITING_FOR_PAYMENT => 'waiting',
        self::IN_PROGRESS => 'warning',
        self::ENDED => 'success',
        self::ERRORS => 'danger',
        self::CANCELED => 'canceled',
        self::PAID => 'info',
        self::UNKNOWN => 'unknown'
    ];

    public static function convertIntToStringStatus(int $status): string
    {
        return self::ORDER_STATUSES[$status] ?? self::UNKNOWN;
    }
    public static function convertStringStatusToInt(string $status): int
    {
        $reverseMapping = array_flip(self::ORDER_STATUSES);
        return $reverseMapping[$status] ?? self::UNKNOWN;
    }
    public static function convertIntToHumanReadableStatus(int $status): string
    {
        return self::HUMAN_READABLE_STATUSES[$status] ?? self::HUMAN_READABLE_STATUSES[self::UNKNOWN];
    }
    public static function convertStringToHumanReadableStatus(string $status): string
    {
        $reverseMapping = array_flip(self::ORDER_STATUSES);
        $intStatus = $reverseMapping[$status] ?? self::UNKNOWN;
        return self::HUMAN_READABLE_STATUSES[$intStatus] ?? self::HUMAN_READABLE_STATUSES[self::UNKNOWN];
    }
    public static function getBadgeNameByIntStatus(?int $status): string
    {
        if(!isset($status)) return self::BADGES[self::UNKNOWN];
        return self::BADGES[$status] ?? self::BADGES[self::UNKNOWN];
    }
    private static function getHumanReadableStatuses(): array
    {
        return self::HUMAN_READABLE_STATUSES;
    }
}