<?php

namespace Epaka\Mapper;

class EpakaOrderProcessResultStatusResultMapper {
    public const WAITING_PAYMENT = -1;
    public const COURIER_TRANSFER_ERROR = 0;
    public const READY_FOR_SHIPMENT = 1;
    public const COURIER_ASSIGNED_LABEL_GENERATION_FAILED = 2;
    public const COURIER_ASSIGNED_NO_LABEL_REQUIRED = 4;
    public const UNKNOWN = 5;

    private const PROCESS_RESULT_STATUSES = array(
        self::WAITING_PAYMENT => 'WAITING_PAYMENT',
        self::COURIER_TRANSFER_ERROR => 'COURIER_TRANSFER_ERROR',
        self::READY_FOR_SHIPMENT => 'READY_FOR_SHIPMENT',
        self::COURIER_ASSIGNED_LABEL_GENERATION_FAILED => 'COURIER_ASSIGNED_LABEL_GENERATION_FAILED',
        self::COURIER_ASSIGNED_NO_LABEL_REQUIRED => 'COURIER_ASSIGNED_NO_LABEL_REQUIRED',
        self::UNKNOWN => 'UNKNOWN_STATUS',
    );
    private const HUMAN_READABLE_STATUSES = [
        self::WAITING_PAYMENT => 'Oczekuje na zapłatę',
        self::COURIER_TRANSFER_ERROR => 'Błąd przekazania do kuriera',
        self::READY_FOR_SHIPMENT => 'Przekazane do kuriera',
        self::COURIER_ASSIGNED_LABEL_GENERATION_FAILED => 'Oczekuje na nadanie (problem z etykietą)',
        self::COURIER_ASSIGNED_NO_LABEL_REQUIRED => 'Przesyłka w drodze (bez etykiety)',
        self::UNKNOWN => 'Nieznany status'
    ];
    private const BADGES = [
        self::WAITING_PAYMENT => 'warning',
        self::COURIER_TRANSFER_ERROR => 'danger',
        self::READY_FOR_SHIPMENT => 'success',
        self::COURIER_ASSIGNED_LABEL_GENERATION_FAILED => 'warning',
        self::COURIER_ASSIGNED_NO_LABEL_REQUIRED => 'info',
        self::UNKNOWN => 'unknown'
    ];

    public static function convertIntToStringStatus(int $status): string
    {
        return self::PROCESS_RESULT_STATUSES[$status] ?? self::UNKNOWN;
    }
    public static function convertStringStatusToInt(string $status): int
    {
        $reverseMapping = array_flip(self::PROCESS_RESULT_STATUSES);
        return $reverseMapping[$status] ?? self::UNKNOWN;
    }
    public static function convertIntToHumanReadableStatus(int $status): string
    {
        return self::HUMAN_READABLE_STATUSES[$status] ?? self::UNKNOWN;
    }
    public static function convertStringToHumanReadableStatus(string $status): string
    {
        $reverseMapping = array_flip(self::PROCESS_RESULT_STATUSES);
        $intStatus = $reverseMapping[$status] ?? self::UNKNOWN;
        return self::HUMAN_READABLE_STATUSES[$intStatus] ?? self::UNKNOWN;
    }
    public static function getBadgeNameByIntStatus(?int $status): string
    {
        if(!isset($status)) return self::BADGES[self::UNKNOWN];
        return self::BADGES[$status] ?? self::BADGES[self::UNKNOWN];
    }
}