<?php

namespace Epaka\Mapper;

class DocumentsLabelFormatMapper {
    public const A4 = 0;
    public const ZEBRA = 1;

    private const DOCUMENT_STATUSES = [
        self::A4 => 'label',
        self::ZEBRA => 'label-zebra',
    ];
    public const HUMAN_READABLE_STATUSES = [
        self::A4 => 'A4',
        self::ZEBRA => 'Zebra',
    ];

    public static function convertIntToStringStatus(int $status): string
    {
        return self::DOCUMENT_STATUSES[$status];
    }
    public static function convertStringStatusToInt(string $status): int
    {
        $reverseMapping = array_flip(self::DOCUMENT_STATUSES);
        return $reverseMapping[$status];
    }
    public static function convertIntToHumanReadableStatus(int $status): string
    {
        return self::HUMAN_READABLE_STATUSES[$status];
    }
    public static function convertStringToHumanReadableStatus(string $status): string
    {
        $reverseMapping = array_flip(self::DOCUMENT_STATUSES);
        $intStatus = $reverseMapping[$status];
        return self::HUMAN_READABLE_STATUSES[$intStatus];
    }
    private static function getHumanReadableStatuses(): array
    {
        return self::HUMAN_READABLE_STATUSES;
    }
}