<?php

namespace Epaka\Mapper;

class CourierStatusMapper
{
    public const PACKAGE_NO_SEND = 0;
    public const PACKAGE_RECEIVED_FROM_SENDER = 1;
    public const PACKAGE_ON_TRANSIT = 2;
    public const PACKAGE_IN_DELIVERY = 3;
    public const PACKAGE_DELIVERED = 4;
    public const PACKAGE_DELIVERY_PROBLEM = 5;
    public const PACKAGE_DAMAGED = 6;
    public const WRONG_ADDRESS = 7;
    public const RETURN_TO_SENDER = 8;
    public const PACKAGE_SENDING_IN_POINT = 9;
    public const PACKAGE_WAITING_IN_POINT = 10;
    public const PACKAGE_SENDING_IN_PACZKOMAT = 11;
    public const PACKAGE_WAITING_IN_PACZKOMAT = 12;

    private const COURIER_STATUSES = [
        self::PACKAGE_NO_SEND => 'package_no_send',
        self::PACKAGE_RECEIVED_FROM_SENDER => 'package_received_from_sender',
        self::PACKAGE_ON_TRANSIT => 'package_on_transit',
        self::PACKAGE_IN_DELIVERY => 'package_in_delivery',
        self::PACKAGE_DELIVERED => 'package_delivered',
        self::PACKAGE_DELIVERY_PROBLEM => 'package_delivery_problem',
        self::PACKAGE_DAMAGED => 'package_damaged',
        self::WRONG_ADDRESS => 'wrong_address',
        self::RETURN_TO_SENDER => 'return_to_sender',
        self::PACKAGE_SENDING_IN_POINT => 'package_sending_in_point',
        self::PACKAGE_WAITING_IN_POINT => 'package_waiting_in_point',
        self::PACKAGE_SENDING_IN_PACZKOMAT => 'package_sending_in_paczkomat',
        self::PACKAGE_WAITING_IN_PACZKOMAT => 'package_waiting_in_paczkomat'
    ];
    public const HUMAN_READABLE_STATUSES = [
        self::PACKAGE_NO_SEND => 'Nie została wysłana',
        self::PACKAGE_RECEIVED_FROM_SENDER => 'Odebrana od nadawcy',
        self::PACKAGE_ON_TRANSIT => 'W tranzycie',
        self::PACKAGE_IN_DELIVERY => 'W doręczeniu',
        self::PACKAGE_DELIVERED => 'Dostarczona',
        self::PACKAGE_DELIVERY_PROBLEM => 'Problem z doręczeniem',
        self::PACKAGE_DAMAGED => 'Uszkodzona',
        self::WRONG_ADDRESS => 'Nieprawidłowy adres',
        self::RETURN_TO_SENDER => 'Zwrot do nadawcy',
        self::PACKAGE_SENDING_IN_POINT => 'Nadana w punkcie',
        self::PACKAGE_WAITING_IN_POINT => 'Oczekuje w punkcie',
        self::PACKAGE_SENDING_IN_PACZKOMAT => 'Nadana w paczkomacie',
        self::PACKAGE_WAITING_IN_PACZKOMAT => 'Oczekuje w paczkomacie'
    ];
    private const BADGES = [
        self::PACKAGE_NO_SEND => 'warning',
        self::PACKAGE_RECEIVED_FROM_SENDER => 'info',
        self::PACKAGE_ON_TRANSIT => 'primary',
        self::PACKAGE_IN_DELIVERY => 'success',
        self::PACKAGE_DELIVERED => 'success',
        self::PACKAGE_DELIVERY_PROBLEM => 'danger',
        self::PACKAGE_DAMAGED => 'danger',
        self::WRONG_ADDRESS => 'danger',
        self::RETURN_TO_SENDER => 'danger',
        self::PACKAGE_SENDING_IN_POINT => 'info',
        self::PACKAGE_WAITING_IN_POINT => 'warning',
        self::PACKAGE_SENDING_IN_PACZKOMAT => 'info',
        self::PACKAGE_WAITING_IN_PACZKOMAT => 'warning'
    ];

    public static function convertIntToStringStatus(int $status): string
    {
        return self::COURIER_STATUSES[$status] ?? self::PACKAGE_NO_SEND;
    }
    public static function convertStringStatusToInt(string $status): int
    {
        $reverseMapping = array_flip(self::COURIER_STATUSES);
        return $reverseMapping[$status] ?? self::PACKAGE_NO_SEND;
    }
    public static function convertIntToHumanReadableStatus(int $status): string
    {
        return self::HUMAN_READABLE_STATUSES[$status] ?? self::HUMAN_READABLE_STATUSES[self::PACKAGE_NO_SEND];
    }
    public static function convertStringToHumanReadableStatus(string $status): string
    {
        $reverseMapping = array_flip(self::COURIER_STATUSES);
        $intStatus = $reverseMapping[$status] ?? self::PACKAGE_NO_SEND;
        return self::HUMAN_READABLE_STATUSES[$intStatus] ?? self::HUMAN_READABLE_STATUSES[self::PACKAGE_NO_SEND];
    }
    public static function getBadgeNameByIntStatus(?int $status): string
    {
        if(!isset($status)) return self::BADGES[self::PACKAGE_NO_SEND];
        return self::BADGES[$status] ?? self::BADGES[self::PACKAGE_NO_SEND];
    }
}