<?php

namespace Epaka\Install;

use Db;
use Exception;

class DatabaseInstaller
{
    public static function installTables()
    {
        $queries = [
            'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'epaka_carrier` (
                `id` INT AUTO_INCREMENT NOT NULL,
                `ps_carrier_id` INT NOT NULL,
                `shipment_type` INT NOT NULL,
                `parcel_type` INT NOT NULL,
                `sender_country_id` INT NOT NULL,
                `receiver_country_id` INT NOT NULL,
                `additional_options` TEXT DEFAULT NULL,
                `epaka_curier_id` INT NOT NULL,
                `epaka_courier_name` VARCHAR(255) NOT NULL,
                `updated_at` DATETIME NOT NULL,
                `created_at` DATETIME NOT NULL,
                `is_point` TINYINT(1) NOT NULL,
                `is_deleted` TINYINT(1) NOT NULL,
                PRIMARY KEY(`id`)
            )ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci',
            'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'epaka_sender` (
                `id` INT AUTO_INCREMENT NOT NULL,
                `carrier_id` INT NOT NULL,
                `company_name` VARCHAR(255) NOT NULL,
                `first_name` VARCHAR(255) NOT NULL,
                `last_name` VARCHAR(255) NOT NULL,
                `country` VARCHAR(255) NOT NULL,
                `street` VARCHAR(255) NOT NULL,
                `house_number` VARCHAR(50) NOT NULL,
                `postal_code` VARCHAR(20) NOT NULL,
                `city` VARCHAR(255) NOT NULL,
                `phone` VARCHAR(50) NOT NULL,
                `email` VARCHAR(255) NOT NULL,
                `created_at` DATETIME NOT NULL,
                PRIMARY KEY(`id`)
            )ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci',
            'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'epaka_auth` (
                `id` INT AUTO_INCREMENT NOT NULL,
                `access_token` VARCHAR(255) NOT NULL,
                `expires_at` DATETIME NOT NULL,
                `refresh_token` VARCHAR(255) NOT NULL,
                `client_id` VARCHAR(255) NOT NULL,
                `client_secret` VARCHAR(255) NOT NULL,
                `created_at` DATETIME NOT NULL,
                PRIMARY KEY(`id`)
            )ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci',
            'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'epaka_order` (
                `id` INT AUTO_INCREMENT NOT NULL,
                `ps_order_id` INT NOT NULL,
                `updated_at` DATETIME NOT NULL,
                `created_at` DATETIME NOT NULL,
                `is_deleted` TINYINT(1) NOT NULL,
                PRIMARY KEY(`id`),
                KEY `ps_order_id` (`ps_order_id`)
            )ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci',
            'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'epaka_parcel` (
                `id` INT AUTO_INCREMENT NOT NULL,
                `epaka_order_id` INT NOT NULL,
                `api_order_id` INT DEFAULT NULL,
                `message` LONGTEXT DEFAULT NULL,
                `order_process_result_status` INT DEFAULT NULL,
                `epaka_status` INT DEFAULT NULL,
                `courier_status` INT DEFAULT NULL,
                `waybill_number` VARCHAR(255) DEFAULT NULL,
                 `is_deleted` TINYINT(1) NOT NULL,
                `epaka_placed_at` DATETIME NULL,
                PRIMARY KEY(`id`),
                KEY `epaka_order_id` (`epaka_order_id`),
                KEY `api_order_id` (`api_order_id`),
                FOREIGN KEY (`epaka_order_id`) REFERENCES `' . _DB_PREFIX_ . 'epaka_order`(`id`) ON DELETE CASCADE
            )ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci',
            'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'epaka_settings` (
                `id` INT AUTO_INCREMENT NOT NULL,
                `payment_type` INT NOT NULL,
                `default_label_format` INT NOT NULL,
                `first_name` VARCHAR(255) DEFAULT NULL,
                `last_name` VARCHAR(255) DEFAULT NULL,
                `company_name` VARCHAR(255) DEFAULT NULL,
                `street` VARCHAR(255) DEFAULT NULL,
                `country` VARCHAR(100) DEFAULT "PL",
                `house_number` VARCHAR(50) DEFAULT NULL,
                `post_code` VARCHAR(20) DEFAULT NULL,
                `city` VARCHAR(255) DEFAULT NULL,
                `phone` VARCHAR(50) DEFAULT NULL,
                `email` VARCHAR(255) DEFAULT NULL,
                `created_at` DATETIME NOT NULL,
                PRIMARY KEY(`id`)
            )ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci'
        ];

        return self::executeQueries($queries);
    }

    public static function uninstallTables()
    {
        $queries = [
            'DROP TABLE IF EXISTS `' . _DB_PREFIX_ . 'epaka_parcel`',
            'DROP TABLE IF EXISTS `' . _DB_PREFIX_ . 'epaka_order`',
            'DROP TABLE IF EXISTS `' . _DB_PREFIX_ . 'epaka_carrier`',
            'DROP TABLE IF EXISTS `' . _DB_PREFIX_ . 'epaka_sender`',
            'DROP TABLE IF EXISTS `' . _DB_PREFIX_ . 'epaka_auth`',
            'DROP TABLE IF EXISTS `' . _DB_PREFIX_ . 'epaka_settings`'
        ];

        return self::executeQueries($queries);
    }

    private static function executeQueries($queries)
    {
        $isPrestashop8Plus = version_compare(_PS_VERSION_, '8.0.0', '>=');

        foreach ($queries as $query) {
            try {
                $result = Db::getInstance()->execute($query);
                if (!$result && $isPrestashop8Plus) {
                    $modifiedQuery = str_replace('`', '', $query);
                    if (!Db::getInstance()->execute($modifiedQuery)) {
                        return false;
                    }
                } elseif (!$result) {
                    return false;
                }
            } catch (Exception $e) {
                if ($isPrestashop8Plus) {
                    try {
                        $modifiedQuery = str_replace('`', '', $query);
                        if (!Db::getInstance()->execute($modifiedQuery)) {
                            return false;
                        }
                    } catch (Exception $e2) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }

        return true;
    }
}