<?php

namespace Epaka\Form;

use Epaka\Mapper\ShippingMapper;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ShippingFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'required' => true,
            ])
            ->add('isDefaultActive', CheckboxType::class, [
                'required' => false,
            ])
            ->add('shippingType', ChoiceType::class, [
                'choices' => [
                    'Koperta' => ShippingMapper::PACKAGE_TYPE_ENVELOPE,
                    'Paczka' => ShippingMapper::PACKAGE_TYPE_PARCEL,
                    'Paleta' => ShippingMapper::PACKAGE_TYPE_PALLET,
                ],

                'expanded' => true,
                'multiple' => false,
                'required' => true,
                'data' => $options['data']['shippingType'] ?? ShippingMapper::PACKAGE_TYPE_PARCEL,
            ])

            ->add('weight', TextType::class, [
                'required' => true,
                'attr' => [
                    'pattern' => '^[0-9]+\.?[0-9]*$',
                    'inputmode' => 'decimal',
                    'onkeypress' => 'return (event.charCode >= 48 && event.charCode <= 57) || event.charCode == 46',
                    'onkeyup' => 'this.value = this.value.replace(/,/g, "."); 
                        if((this.value.match(/\./g)||[]).length > 1){ 
                            this.value = this.value.slice(0, -1); 
                        }
                        if(this.value.startsWith(".")){ 
                            this.value = ""; 
                        }'
                ]
            ])
            ->add('parcelType', ChoiceType::class, [
                'choices' => [
                    'Standardowe' => ShippingMapper::PARCEL_TYPE_STANDARD,
                    'Niestandardowe' => ShippingMapper::PARCEL_TYPE_TYPE_NOT_STANDARD,
                ],
                'multiple' => false,
                'required' => true,
                'data' =>  ShippingMapper::PARCEL_TYPE_STANDARD,
                'attr' => [
                    'data-api-select-name' => 'packageType'
                ]
            ])
            ->add('length', TextType::class, [
                'required' => true,
                'attr' => [
                    'pattern' => '^[0-9]*$',
                    'inputmode' => 'decimal',
                    'onkeypress' => 'return (event.charCode >= 48 && event.charCode <= 57) || event.charCode == 46',
                    'onkeyup' => 'this.value = this.value.replace(/,/g, "."); 
                        if((this.value.match(/\./g)||[]).length > 1){ 
                            this.value = this.value.slice(0, -1); 
                        }
                        if(this.value.startsWith(".")){ 
                            this.value = ""; 
                        }'
                ]
            ])
            ->add('width', TextType::class, [
                'required' => true,
                'attr' => [
                    'pattern' => '^[0-9]*$',
                    'inputmode' => 'decimal',
                    'onkeypress' => 'return (event.charCode >= 48 && event.charCode <= 57) || event.charCode == 46',
                    'onkeyup' => 'this.value = this.value.replace(/,/g, "."); 
                        if((this.value.match(/\./g)||[]).length > 1){ 
                            this.value = this.value.slice(0, -1); 
                        }
                        if(this.value.startsWith(".")){ 
                            this.value = ""; 
                        }'
                ]
            ])
            ->add('height', TextType::class, [
                'required' => true,
                'attr' => [
                    'pattern' => '^[0-9]*$',
                    'inputmode' => 'decimal',
                    'onkeypress' => 'return (event.charCode >= 48 && event.charCode <= 57) || event.charCode == 46',
                    'onkeyup' => 'this.value = this.value.replace(/,/g, "."); 
                        if((this.value.match(/\./g)||[]).length > 1){ 
                            this.value = this.value.slice(0, -1); 
                        }
                        if(this.value.startsWith(".")){ 
                            this.value = ""; 
                        }'
                ]
            ])
            ->add('senderCountry', ChoiceType::class, [
                'choices' => array_flip($options['countries']),
                'multiple' => false,
                'required' => true,
                'data' => 'PL', // Poland
                'attr' => [
                    'data-api-select-name' => 'senderCountry'
                ]
            ])
            ->add('receiverCountry', ChoiceType::class, [
                'choices' => array_flip($options['countries']),
                'multiple' => false,
                'required' => true,
                'data' => 'PL', // Poland
                'attr' => [
                    'data-api-select-name' => 'receiverCountry'
                ]
            ])
            ->add('submit', SubmitType::class);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'countries' => [],
        ]);
    }
}