<?php

namespace Epaka\Form;

use Epaka\Service\ApiFieldLengthService;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SettingsFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $choices = array_flip($options['defaultLabelFormatChoices']);
        $builder
           ->add('login', TextType::class, [
               'attr' => [
                   'value' => $options['userEmail'] ?? null,
               ],
               'required' => false,
               'mapped' => false,
           ])
           ->add('password', PasswordType::class, [
               'required' => false,
               'disabled' => true,
               'attr' => [
                   'value' => '************************',
               ],
               'mapped' => false,
           ])
           ->add('paymentType', ChoiceType::class, [
               'choices' => array_flip($options['paymentTypes']),
           ])
           ->add('defaultLabelFormat', ChoiceType::class, [
               'choices' => $choices,
               'expanded' => true,
               'multiple' => false,
           ])
            ->add('companyName', TextType::class, [
                'required' => false,
                'attr' => [
                    'minlength' => ApiFieldLengthService::senderCompanyMin(),
                    'maxlength' => ApiFieldLengthService::senderCompanyMax(),
                    'onkeypress' => 'return !/[^\p{L}\p{N} ]/u.test(String.fromCharCode(event.charCode))',
                    'onkeyup' => 'this.value = this.value.replace(/[^\p{L}\p{N} ]/gu, "");
                  if (this.value.length > 100) this.value = this.value.slice(0, 100);'
                ]
            ])
            ->add('firstName', TextType::class, [
                'required' => false,
                'attr' => [
                    'minlength' => ApiFieldLengthService::senderFirstnameMin(),
                    'maxlength' => ApiFieldLengthService::senderFirstnameMax(),
                    'oninput' => 'if(this.value.length > 100) this.value = this.value.slice(0, 100);'
                ]
            ])
            ->add('lastName', TextType::class, [
                'required' => false,
                'attr' => [
                    'minlength' => ApiFieldLengthService::senderLastnameMin(),
                    'maxlength' => ApiFieldLengthService::senderLastnameMax(),
                    'oninput' => 'if(this.value.length > 100) this.value = this.value.slice(0, 100);'
                ]
            ])
            ->add('street', TextType::class, [
                'required' => false,
                'attr' => [
                    'minlength' => ApiFieldLengthService::senderAddress1Min(),
                    'maxlength' => ApiFieldLengthService::senderAddress1Max(),
                    'oninput' => 'if(this.value.length > 60) this.value = this.value.slice(0, 60);'
                ]
            ])
            ->add('houseNumber', TextType::class, [
                'required' => false,
                'attr' => [
                    'minlength' => ApiFieldLengthService::receiverAddress2Min(),
                    'maxlength' => ApiFieldLengthService::receiverAddress2Max(),
                    'oninput' => 'if(this.value.length > 7) this.value = this.value.slice(0, 7);'
                ]
            ])
            ->add('postCode', TextType::class, [
                'required' => false,
            ])
            ->add('country', ChoiceType::class, [
                'choices' => array_flip($options['countries']),
                'multiple' => false,
                'required' => false,
                'data' => 'PL', // Poland
            ])
            ->add('city', TextType::class, [
                'required' => false,
                'attr' => [
                    'minlength' => ApiFieldLengthService::senderCityMin(),
                    'maxlength' => ApiFieldLengthService::senderCityMax(),
                    'oninput' => 'if(this.value.length > 50) this.value = this.value.slice(0, 50);'
                ]
            ])
            ->add('phone', TextType::class, [
                'required' => false,
                'attr' => [
                    'minlength' => ApiFieldLengthService::senderPhoneMin(),
                    'maxlength' => ApiFieldLengthService::senderPhoneMax(),
                    'oninput' => 'if(this.value.length > 15) this.value = this.value.slice(0, 15);'
                ]
            ])
            ->add('email', EmailType::class, [
                'required' => false,
                'attr' => [
                    'minlength' => ApiFieldLengthService::customerEmailMin(),
                    'maxlength' => ApiFieldLengthService::customerEmailMax(),
                    'oninput' => 'if(this.value.length > 100) this.value = this.value.slice(0, 100);',
                ]
            ])
           ->add('send', SubmitType::class)
           ->add('connectToEpakaAccountButton', SubmitType::class);
    }
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'userEmail' => null,
            'defaultLabelFormatChoices' => null,
            'paymentTypes' => null,
            'countries' => [],
        ]);
    }
}