<?php

namespace Epaka\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PriceToFrontendFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder            
            ->add('price', TextType::class, [
                'required' => true,
                'attr' => [
                    'pattern' => '^[0-9]+\.?[0-9]*$',
                    'inputmode' => 'decimal',
                    'onkeypress' => 'return (event.charCode >= 48 && event.charCode <= 57) || event.charCode == 46',
                    'onkeyup' => 'this.value = this.value.replace(/,/g, "."); 
                        if((this.value.match(/\./g)||[]).length > 1){ 
                            this.value = this.value.slice(0, -1); 
                        }
                        if(this.value.startsWith(".")){ 
                            this.value = ""; 
                        }'
                ]
                ]);
                
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => null,
        ]);
    }
}