<?php

namespace Epaka\Form;

use Epaka\Service\ApiFieldLengthService;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\OptionsResolver\OptionsResolver;

class DefaultSenderFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('companyName', TextType::class, [
                'required' => true,
                'attr' => [
                    'minlength' => ApiFieldLengthService::senderCompanyMin(),
                    'maxlength' => ApiFieldLengthService::senderCompanyMax(),
                    'onkeypress' => 'return !/[^\p{L}\p{N} ]/u.test(String.fromCharCode(event.charCode))',
                    'onkeyup' => 'this.value = this.value.replace(/[^\p{L}\p{N} ]/gu, "");
                  if (this.value.length > 100) this.value = this.value.slice(0, 100);'
                ]
            ])
            ->add('firstName', TextType::class, [
                'required' => true,
                'attr' => [
                    'minlength' => ApiFieldLengthService::senderFirstnameMin(),
                    'maxlength' => ApiFieldLengthService::senderFirstnameMax(),
                    'oninput' => 'if(this.value.length > 100) this.value = this.value.slice(0, 100);'
                ]
            ])
            ->add('lastName', TextType::class, [
                'required' => true,
                'attr' => [
                    'minlength' => ApiFieldLengthService::senderLastnameMin(),
                    'maxlength' => ApiFieldLengthService::senderLastnameMax(),
                    'oninput' => 'if(this.value.length > 100) this.value = this.value.slice(0, 100);'
                ]
            ])
            ->add('street', TextType::class, [
                'required' => true,
                'attr' => [
                    'minlength' => ApiFieldLengthService::senderAddress1Min(),
                    'maxlength' => ApiFieldLengthService::senderAddress1Max(),
                    'oninput' => 'if(this.value.length > 60) this.value = this.value.slice(0, 60);'
                ]
            ])
            ->add('houseNumber', TextType::class, [
                'required' => true,
                'attr' => [
                    'minlength' => ApiFieldLengthService::receiverAddress2Min(),
                    'maxlength' => ApiFieldLengthService::receiverAddress2Max(),
                    'oninput' => 'if(this.value.length > 7) this.value = this.value.slice(0, 7);'
                ]
            ])
            ->add('postCode', TextType::class, [
                'required' => true,
            ])
            ->add('country', ChoiceType::class, [
                'choices' => array_flip($options['countries']),
                'multiple' => false,
                'required' => true,
                'data' => $options['selectCountry'] ?? 'PL', // Poland
            ])
            ->add('city', TextType::class, [
                'required' => true,
                'attr' => [
                    'minlength' => ApiFieldLengthService::senderCityMin(),
                    'maxlength' => ApiFieldLengthService::senderCityMax(),
                    'oninput' => 'if(this.value.length > 50) this.value = this.value.slice(0, 50);'
                ]
            ])
            ->add('phone', TextType::class, [
                'required' => true,
                'attr' => [
                    'minlength' => ApiFieldLengthService::senderPhoneMin(),
                    'maxlength' => ApiFieldLengthService::senderPhoneMax(),
                    'oninput' => 'if(this.value.length > 15) this.value = this.value.slice(0, 15);'
                ]
            ])
            ->add('email', EmailType::class, [
                'required' => true,
                'attr' => [
                    'minlength' => ApiFieldLengthService::customerEmailMin(),
                    'maxlength' => ApiFieldLengthService::customerEmailMax(),
                    'oninput' => 'if(this.value.length > 100) this.value = this.value.slice(0, 100);',
                ]
            ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => null,
            'countries' => [],
            'selectCountry' => ''
        ]);
    }
}