<?php

namespace Epaka\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class CourierFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $couriers = $options['couriers'] ?? [];
        $choiceAttr = [];
        foreach ($couriers as $courier) {
            $choices[$courier['id']] = $courier['name'];  
            $choiceAttr[$courier['id']] = [   
                'data-name' => $courier['name'],
                'data-price' => $courier['price'],
                'data-logo' => $courier['logo'],
                'data-is-selected' => $courier['isSelected']
            ];
        }
        $builder->add('courier', ChoiceType::class, [
            'choices' => array_flip($choices),
            'multiple' => false,
            'required' => true,
            'expanded' => true,
            'choice_attr' => function($choice, $key, $value) use ($choiceAttr) {
                return $choiceAttr[$value] ?? [];
            },
            'label' => false,
            'attr' => [
                'class' => 'form-check-input'
            ],
            'label_attr' => [
                'class' => 'form-check-label'
            ]
        ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => null,
            'couriers' => []
        ]);
    }
}