<?php

namespace Epaka\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;

class AuthFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
       $builder
           ->add('email', EmailType::class, [
               'required' => true,
           ])
           ->add('clientId', TextType::class, [
               'required' => true,
           ])
           ->add('clientSecret', TextType::class, [
               'required' => true,
           ])
           ->add('password', PasswordType::class, [
               'required' => true,
           ])
            ->add('send', SubmitType::class);
    }
}