<?php
namespace Epaka\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class AdditionalCourierSettingsFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $services = $options['options']['services'] ?? [];
        foreach ($services as $service) {
            $hasExtraField = isset($service['extra_field']);
            if ($service['fieldState']['isActive']) {
                $checkboxAttrs = [
                    'data-api-name' => $service['apiName'] ?? '',
                    'data-api-price' => $hasExtraField ? '0' : ($service['price'] ?? ''),
                    'checked' => 'checked',
                ];
            } else {
                $checkboxAttrs = [
                    'data-api-name' => $service['apiName'] ?? '',
                    'data-api-price' => $hasExtraField ? '0' : ($service['price'] ?? ''),
                ];
            }
            if (isset($service['nonConnectingServices']) && is_array($service['nonConnectingServices'])) {
                $checkboxAttrs['data-non-connecting'] = implode(',', $service['nonConnectingServices']);
            }
            $builder->add($service['name'], CheckboxType::class, [
                'label' => $service['label'],
                'data' => $service['selected'] ?? false,
                'help' => isset($service['maxValue']) ? (string)$service['maxValue'] : null,
                'attr' => $checkboxAttrs,

            ]);
            if (isset($service['extra_field'])) {
                $builder->add($service['extra_field']['name'], TextType::class, [
                    'label' => $service['extra_field']['label'],
                    'help' => isset($service['maxValue']) ? (string)$service['maxValue'] : null,
                    'required' => false,
                    'attr' => [
                        'pattern' => '^[0-9]+\.?[0-9]*$',
                        'data-name' => $service['apiName'] ?? '',
                        'inputmode' => 'decimal',
                        'onkeypress' => 'return (event.charCode >= 48 && event.charCode <= 57) || event.charCode == 46',
                        'onkeyup' => 'this.value = this.value.replace(/,/g, "."); 
                        if((this.value.match(/\\./g)||[]).length > 1){ 
                            this.value = this.value.slice(0, -1); 
                        }
                        if(this.value.startsWith(".")){ 
                            this.value = ""; 
                        }',
                        'aria-label' => $service['extra_field']['label'] . ' input',
                        'class' => 'form-control',
                        'value' =>  $service['fieldState']['amount'] ?? '',
                    ]
                ]);
            }
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => null,
            'options' => []
        ]);
    }
}