<?php

namespace Epaka\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name=EpakaParcel::TABLE_NAME)
 * @ORM\Entity()
 * @ORM\HasLifecycleCallbacks()
 */
class EpakaParcel
{
    private const TABLE_SUFFIX = 'epaka_parcel';
    public const TABLE_NAME = _DB_PREFIX_ . self::TABLE_SUFFIX;

    /**
     * @var int
     * @ORM\Id
     * @ORM\Column(name="id", type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     * @ORM\Column(name="epaka_order_id", type="integer")
     */
    private $epakaOrderId;

    /**
     * @var int
     * @ORM\Column(name="api_order_id", type="integer")
     */
    private $apiOrderId;

    /**
     * @var string|null
     * @ORM\Column(name="message", type="text", nullable=true)
     */
    private $message;

    /**
     * @var int
     * @ORM\Column(name="order_process_result_status", type="integer")
     */
    private $orderProcessResultStatus;

    /**
     * @var int
     * @ORM\Column(name="epaka_status", type="integer")
     */
    private $epakaStatus;

    /**
     * @var int
     * @ORM\Column(name="courier_status", type="integer")
     */
    private $courierStatus;

    /**
     * @var string|null
     * @ORM\Column(name="waybill_number", type="string", length=255, nullable=true)
     */
    private $waybillNumber;

    /**
     * @var DateTime
     * @ORM\Column(name="epaka_placed_at", type="datetime")
     */
    private $epakaPlacedAt;

    /**
     * @var bool
     * @ORM\Column(name="is_deleted", type="boolean")
     */
    private $isDeleted = false;

    public function getId(): int
    {
        return $this->id;
    }

    public function getEpakaOrderId(): int
    {
        return $this->epakaOrderId;
    }

    public function setEpakaOrderId(int $epakaOrderId): self
    {
        $this->epakaOrderId = $epakaOrderId;
        return $this;
    }

    public function getApiOrderId(): int
    {
        return $this->apiOrderId;
    }

    public function setApiOrderId(int $apiOrderId): self
    {
        $this->apiOrderId = $apiOrderId;
        return $this;
    }

    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function setMessage(?string $message): self
    {
        $this->message = $message;
        return $this;
    }

    public function getOrderProcessResultStatus(): int
    {
        return $this->orderProcessResultStatus;
    }

    public function setOrderProcessResultStatus(int $orderProcessResultStatus): self
    {
        $this->orderProcessResultStatus = $orderProcessResultStatus;
        return $this;
    }

    public function getEpakaStatus(): int
    {
        return $this->epakaStatus;
    }

    public function setEpakaStatus(int $epakaStatus): self
    {
        $this->epakaStatus = $epakaStatus;
        return $this;
    }

    public function getCourierStatus(): int
    {
        return $this->courierStatus;
    }

    public function setCourierStatus(int $courierStatus): self
    {
        $this->courierStatus = $courierStatus;
        return $this;
    }

    public function getWaybillNumber(): ?string
    {
        return $this->waybillNumber;
    }

    public function setWaybillNumber(?string $waybillNumber): self
    {
        $this->waybillNumber = $waybillNumber;
        return $this;
    }

    public function getEpakaPlacedAt(): DateTime
    {
        return $this->epakaPlacedAt;
    }

    public function setEpakaPlacedAt(DateTime $epakaPlacedAt): self
    {
        $this->epakaPlacedAt = $epakaPlacedAt;
        return $this;
    }

    public function isDeleted(): bool
    {
        return $this->isDeleted;
    }

    public function setIsDeleted(bool $isDeleted): self
    {
        $this->isDeleted = $isDeleted;
        return $this;
    }
}