<?php

namespace Epaka\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name=EpakaOrder::TABLE_NAME)
 * @ORM\Entity()
 * @ORM\HasLifecycleCallbacks()
 */
class EpakaOrder
{
    private const TABLE_SUFFIX = 'epaka_order';
    public const TABLE_NAME = _DB_PREFIX_ . self::TABLE_SUFFIX;

    /**
     * @var int
     * @ORM\Id
     * @ORM\Column(name="id", type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     * @ORM\Column(name="ps_order_id", type="integer")
     */
    private $psOrderId;

    /**
     * @var DateTime
     * @ORM\Column(name="updated_at", type="datetime")
     */
    private $updatedAt;

    /**
     * @var DateTime
     * @ORM\Column(name="created_at", type="datetime")
     */
    private $createdAt;

    /**
     * @var bool
     * @ORM\Column(name="is_deleted", type="boolean")
     */
    private $isDeleted = false;

    public function getId(): int
    {
        return $this->id;
    }

    public function getPsOrderId(): int
    {
        return $this->psOrderId;
    }

    public function setPsOrderId(int $psOrderId): self
    {
        $this->psOrderId = $psOrderId;
        return $this;
    }

    public function getUpdatedAt(): DateTime
    {
        return $this->updatedAt;
    }

    public function setUpdatedAt(DateTime $updatedAt): self
    {
        $this->updatedAt = $updatedAt;
        return $this;
    }

    public function getCreatedAt(): DateTime
    {
        return $this->createdAt;
    }

    public function setCreatedAt(DateTime $createdAt): self
    {
        $this->createdAt = $createdAt;
        return $this;
    }

    public function isDeleted(): bool
    {
        return $this->isDeleted;
    }

    public function setIsDeleted(bool $isDeleted): self
    {
        $this->isDeleted = $isDeleted;
        return $this;
    }
}