<?php

namespace Epaka\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name=EpakaCarrier::TABLE_NAME)
* @ORM\Entity()
*/
class EpakaCarrier
{
    private const TABLE_SUFFIX = 'epaka_carrier';
    public const TABLE_NAME = _DB_PREFIX_ . self::TABLE_SUFFIX;
   /**
    * @var int
    *
    * @ORM\Id
    * @ORM\Column(name="id", type="integer")
    * @ORM\GeneratedValue(strategy="AUTO")
    */
   private $id;

   /**
    * @var int
    *
    * @ORM\Column(name="ps_carrier_id", type="integer")
    */
   private $psCarrierId;

   /**
    * @var int
    *
    * @ORM\Column(name="shipment_type", type="integer") 
    */
   private $shipmentType;

   /**
    * @var int
    *
    * @ORM\Column(name="parcel_type", type="integer")
    */
   private $parcelType;

   /**
    * @var int
    *
    * @ORM\Column(name="sender_country_id", type="integer")
    */
   private $senderCountryId;

   /**
    * @var int
    *
    * @ORM\Column(name="receiver_country_id", type="integer")
    */
   private $receiverCountryId;

   /**
    * @var array|null
    *
    * @ORM\Column(name="additional_options", type="text", nullable=true)
    */
   private $additionalOptions;

   /**
    * @var int
    *
    * @ORM\Column(name="epaka_curier_id", type="integer")
    */
   private $epakaCurierId;

    /**
     * @var string
     *
     * @ORM\Column(name="epaka_courier_name", type="string")
     */
    private $epakaCourierName;

    /**
     * @var DateTime
     *
     * @ORM\Column(name="updated_at", type="datetime")
     */
    private $updatedAt;

    /**
     * @var bool
     *
     * @ORM\Column(name="is_deleted", type="boolean")
     */
    private $isDeleted = false;

    /**
     * @var bool
     *
     * @ORM\Column(name="is_point", type="boolean")
     */
    private $isPoint = false;

    /**
     * @var DateTime
     *
     * @ORM\Column(name="created_at", type="datetime")
     */
    private $createdAt;


    /**
    * @return int
    */
   public function getId()
   {
       return $this->id;
   }

   /**
    * @return int
    */
   public function getPsCarrierId()
   {
       return $this->psCarrierId;
   }

   /**
    * @param int $psCarrierId
    * @return EpakaCarrier
    */
   public function setPsCarrierId($psCarrierId)
   {
       $this->psCarrierId = $psCarrierId;
       return $this;
   }

   /**
    * @return int
    */
   public function getShipmentType()
   {
       return $this->shipmentType;
   }

   /**
    * @param int $shipmentType
    * @return EpakaCarrier
    */
   public function setShipmentType($shipmentType)
   {
       $this->shipmentType = $shipmentType;
       return $this;
   }

   /**
    * @return int
    */
   public function getParcelType()
   {
       return $this->parcelType;
   }

   /**
    * @param int $parcelType
    * @return EpakaCarrier
    */
   public function setParcelType($parcelType)
   {
       $this->parcelType = $parcelType;
       return $this;
   }

   /**
    * @return int
    */
   public function getSenderCountryId()
   {
       return $this->senderCountryId;
   }

   /**
    * @param int $senderCountryId
    * @return EpakaCarrier
    */
   public function setSenderCountryId($senderCountryId)
   {
       $this->senderCountryId = $senderCountryId;
       return $this;
   }

   /**
    * @return int
    */
   public function getReceiverCountryId()
   {
       return $this->receiverCountryId;
   }

   /**
    * @param int $receiverCountryId
    * @return EpakaCarrier
    */
   public function setReceiverCountryId($receiverCountryId)
   {
       $this->receiverCountryId = $receiverCountryId;
       return $this;
   }

   /**
    * @return array|null
    */
   public function getAdditionalOptions()
   {
    return !empty($this->additionalOptions) ? json_decode($this->additionalOptions, true) : null;
   }

   /**
    * @param array|null $additionalOptions
    * @return EpakaCarrier
    */
   public function setAdditionalOptions($additionalOptions)
   {
    $this->additionalOptions = !empty($additionalOptions) ? json_encode($additionalOptions) : null;
    return $this;
   }

   /**
    * @return int
    */
   public function getEpakaCurierId()
   {
       return $this->epakaCurierId;
   }

   /**
    * @param int $epakaCurierId
    * @return EpakaCarrier
    */
   public function setEpakaCurierId($epakaCurierId)
   {
       $this->epakaCurierId = $epakaCurierId;
       return $this;
   }

    /**
     * @return string
     */
    public function getEpakaCourierName(): string
    {
        return $this->epakaCourierName;
    }

    /**
     * @param string $epakaCourierName
     * @return EpakaCarrier
     */
    public function setEpakaCourierName(string $epakaCourierName): self
    {
        $this->epakaCourierName = $epakaCourierName;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @return DateTime
     */
    public function setUpdatedAt(DateTime $updatedAt)
    {
        $this->updatedAt = $updatedAt;
        return $this;
    }

    /**
     * @return bool
     */
    public function isDeleted(): bool
    {
        return $this->isDeleted;
    }

    /**
     * @param bool $isDeleted
     */
    public function setIsDeleted(bool $isDeleted)
    {
        $this->isDeleted = $isDeleted;
    }

    /**
     * @return bool
     */
    public function isPoint(): bool
    {
        return $this->isPoint;
    }

    /**
     * @param bool $isPoint
     */
    public function setIsPoint(bool $isPoint)
    {
        $this->isPoint = $isPoint;
    }

    /**
     * @return DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @return DateTime
     */
    public function setCreatedAt(DateTime $createdAt)
    {
        $this->createdAt = $createdAt;
        return $this;
    }

   /**
    * @return array
    */
   public function toArray()
   {
       return [
           'carrierId' => $this->getId(),
           'psCarrierId' => $this->getPsCarrierId(),
           'shipmentType' => $this->getShipmentType(),
           'parcelType' => $this->getParcelType(),
           'senderCountryId' => $this->getSenderCountryId(),
           'receiverCountryId' => $this->getReceiverCountryId(),
           'additionalOptions' => $this->getAdditionalOptions(),
           'epakaCurierId' => $this->getEpakaCurierId()
       ];
   }
}