<?php

namespace Epaka\Controller;

use DateTime;
use Epaka\Entity\EpakaAuth;
use Epaka\Entity\EpakaSettings;
use Epaka\Form\AuthFormType;
use Epaka\Mapper\DocumentsLabelFormatMapper;
use Epaka\Mapper\PaymentTypeMapper;
use Epaka\Service\ApiService;
use Epaka\Service\CryptoService;
use Exception;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;


class AuthController extends FrameworkBundleAdminController
{
    protected $em;

    public function __construct()
    {
        parent::__construct();
    }

    public function authAction(Request $request): Response
    {
        $em = $this->getDoctrine()->getManager();
        $authRecord = $em->getRepository(EpakaAuth::class)->findOneBy([]) ?? null;
        if($authRecord) return $this->redirectToRoute('list_of_shipping');
        $form = $this->createForm(AuthFormType::class);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();
            $email = $data['email'];
            $password = $data['password'];
            $clientId = $data['clientId'];
            $clientSecret = $data['clientSecret'];
            try {   
                $authData =  ApiService::fetchToken($email, $password, $clientId, $clientSecret);
                $authRecord = new EpakaAuth();
                $authRecord->setAccessToken($authData['access_token']);
                $authRecord->setRefreshToken($authData['refresh_token']);
                $expiresTimestamp = time() + $authData['expires_in'];
                $expiresAt = new DateTime("@$expiresTimestamp");
                $authRecord->setExpiresAt($expiresAt);
                $authRecord->setClientId(CryptoService::encrypt($clientId, '4wHLnV9WVOADoNS'));
                $authRecord->setClientSecret(CryptoService::encrypt($clientSecret, '4wHLnV9WVOADoNS'));
                $authRecord->setCreatedAt(new DateTime());
                $em->persist($authRecord);
                $epakaSettings = $em->getRepository(EpakaSettings::class)->findOneBy([]) ?? null;
                if(!$epakaSettings) {
                    $epakaSettings = new EpakaSettings();
                    $epakaSettings->setCreatedAt(new DateTime('now'));
                    $epakaSettings->setDefaultLabelFormat(DocumentsLabelFormatMapper::A4);
                    $epakaSettings->setPaymentType(PaymentTypeMapper::BALANCE);
                    $em->persist($epakaSettings);
                }
                $em->flush();
                return $this->redirectToRoute('list_of_shipping');
            } catch (Exception $e) {
                $this->addFlash('error', 'Coś poszło nie tak. Skontaktuj się z epaka.pl w celu uzyskania pomocy.');
            }
        }

        $em->flush();
        $logo = __PS_BASE_URI__ . 'modules/epaka/views/img/logo.png';
        return $this->render('@Modules/epaka/views/templates/admin/auth/auth.html.twig', [
            'form' => $form->createView(),
            'logo' => $logo,
        ]);
    }
}