<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

require_once __DIR__ . '/vendor/autoload.php';

use Epaka\Entity\EpakaParcel;
use Epaka\Entity\EpakaSender;
use Epaka\Entity\EpakaCarrier;
use Epaka\Entity\EpakaOrder;
use Epaka\Install\DatabaseInstaller;
use Epaka\Service\ApiFieldLengthService;

class Epaka extends Module
{
    protected $css_path;
    protected $js_path;
    public $bootstrap;
    public $confirmUninstall;

    public function __construct()
    {
        $this->name = 'epaka';
        $this->tab = 'shipping_logistics';
        $this->version = '1.1.5';
        $this->author = 'epaka.pl';
        $this->need_instance = 0;
        $this->ps_versions_compliancy = [
            'min' => '1.7.6',
            'max' => _PS_VERSION_,
        ];
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = 'epaka.pl';
        $this->description = 'Tani kurier i przesyłki kurierskie';
        $this->confirmUninstall = 'Czy na pewno chcesz odinstalować?';

        $this->css_path = $this->_path . 'views/css/';
        $this->js_path = $this->_path . 'views/js/';
        require_once __DIR__ . '/vendor/autoload.php';
    }

    public function install()
    {
        $this->cleanupAuthorizations();
        if (!class_exists('\\Epaka\\Install\\DatabaseInstaller')) {
            require_once __DIR__ . '/src/Install/DatabaseInstaller.php';
        }

        if (!DatabaseInstaller::installTables()) {
            return false;
        }

        if (!parent::install()) {
            return false;
        }

        // Register hooks
        $hooks = [
            'displayBackOfficeHeader',
            'actionCarrierUpdate',
            'actionAdminControllerSetMedia',
            'actionValidateOrderAfter',
            'actionOrderHistoryAddAfter',
            'additionalCustomerAddressFields',
            'actionValidateCustomerAddressForm',
            'displayCarrierExtraContent',
            'actionFrontControllerSetMedia',
            'actionValidateOrder'
        ];

        foreach ($hooks as $hook) {
            if (!$this->registerHook($hook)) {
                return false;
            }
        }

        return true;
    }

    public function uninstall()
    {
        $idParentTab = (int)Tab::getIdFromClassName('AdminEpakaParent');
        if ($idParentTab) {
            $this->uninstallTab();
        }
        $tables = Db::getInstance()->executeS("SHOW TABLES LIKE '" . _DB_PREFIX_ . "epaka_carrier'");
        if (!empty($tables)) {
            $query = 'SELECT ps_carrier_id FROM ' . _DB_PREFIX_ . 'epaka_carrier';
            $carrierData = Db::getInstance()->executeS($query);

            if ($carrierData) {
                foreach ($carrierData as $row) {
                    $carrier = new Carrier((int)$row['ps_carrier_id']);
                    if (Validate::isLoadedObject($carrier)) {
                        $carrier->deleted = 1;
                        $carrier->update();
                    }
                }
            }
        }
        DatabaseInstaller::uninstallTables();

        return parent::uninstall();
    }

    public function disable($forceAll = false)
    {
        if (!parent::disable($forceAll)) {
            return false;
        }
        $idParentTab = (int)Tab::getIdFromClassName('AdminEpakaParent');
        if ($idParentTab) {
            $this->uninstallTab();
        }
        try {
            $tables = Db::getInstance()->executeS("SHOW TABLES LIKE '" . _DB_PREFIX_ . "epaka_carrier'");
            if (!empty($tables)) {
                $query = "SELECT ps_carrier_id FROM " . _DB_PREFIX_ . "epaka_carrier WHERE is_deleted = 0";
                $carrierData = Db::getInstance()->executeS($query);
                if ($carrierData) {
                    foreach ($carrierData as $row) {
                        $psCarrierId = (int)$row['ps_carrier_id'];
                        Db::getInstance()->execute("UPDATE " . _DB_PREFIX_ . "carrier SET active = 0 WHERE id_carrier = " . $psCarrierId);
                    }
                }
            }
        } catch (Exception $e) {
        }

        return true;
    }

    public function enable($forceAll = false)
    {
        if (!parent::enable($forceAll)) {
            return false;
        }
        $idParentTab = (int)Tab::getIdFromClassName('AdminEpakaParent');
        if (!$idParentTab) {
            $this->installTab();
        }
        try {
            $tables = Db::getInstance()->executeS("SHOW TABLES LIKE '" . _DB_PREFIX_ . "epaka_carrier'");
            if (!empty($tables)) {
                $query = "SELECT ps_carrier_id FROM " . _DB_PREFIX_ . "epaka_carrier WHERE is_deleted = 0";
                $carrierData = Db::getInstance()->executeS($query);
                if ($carrierData) {
                    foreach ($carrierData as $row) {
                        $psCarrierId = (int)$row['ps_carrier_id'];
                        Db::getInstance()->execute("UPDATE " . _DB_PREFIX_ . "carrier SET active = 1 WHERE id_carrier = " . $psCarrierId);
                    }
                }
            }
        } catch (Exception $e) {
        }

        return true;
    }

    private function installTab()
    {
        $parentTab = new Tab();
        $parentTab->active = 1;
        $parentTab->class_name = 'AdminEpakaParent';
        $parentTab->name = [];
        foreach (Language::getLanguages(true) as $lang) {
            $parentTab->name[$lang['id_lang']] = 'epaka.pl';
        }
        $parentTab->id_parent = version_compare(_PS_VERSION_, '8.0.0', '<')
            ? (int)Tab::getIdFromClassName('SELL')
            : $this->get('prestashop.core.admin.tab.repository')->findOneIdByClassName('SELL');
        $parentTab->module = $this->name;
        $parentTab->icon = 'local_shipping';
        if (!$parentTab->add()) {
            return false;
        }

        $childrenTabs = [
            [
                'class_name' => 'AdminEpakaOrders',
                'name' => 'Zamówienia',
                'route_name' => 'list_of_order',
                'legacy_controller' => 'AdminEpakaOrders',
                'legacy_link' => 'AdminEpakaOrders'
            ],
            [
                'class_name' => 'AdminEpakaShipments',
                'name' => 'Przesyłki',
                'route_name' => 'list_of_shipment',
                'legacy_controller' => 'AdminEpakaShipments',
                'legacy_link' => 'AdminEpakaShipments'
            ],
            [
                'class_name' => 'AdminEpakaTemplates',
                'name' => 'Szablony przesyłek',
                'route_name' => 'list_of_shipping',
                'legacy_controller' => 'AdminEpakaTemplates',
                'legacy_link' => 'AdminEpakaTemplates'
            ],
            [
                'class_name' => 'AdminEpakaSettings',
                'name' => 'Ustawienia',
                'route_name' => 'admin_settings',
                'legacy_controller' => 'AdminEpakaSettings',
                'legacy_link' => 'AdminEpakaSettings'
            ]
        ];

        foreach ($childrenTabs as $child) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = $child['class_name'];
            $tab->name = [];
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = $child['name'];
            }
            $tab->id_parent = $parentTab->id;
            $tab->module = $this->name;
            $tab->route_name = $child['route_name'];
            if (isset($child['legacy_controller'])) {
                $tab->wording = $child['legacy_controller'];
                $tab->wording_domain = 'Modules.Epaka.Admin';
            }

            if (!$tab->add()) {
                return false;
            }
        }

        return true;
    }

    public function reset()
    {
        return true;
    }

    private function uninstallTab()
    {
        $childrenTabs = [
            'AdminEpakaOrders',
//            'AdminEpakaShipping',
            'AdminEpakaShipments',
            'AdminEpakaTemplates',
            'AdminEpakaSettings'
        ];
        $tabRepository = $this->get('prestashop.core.admin.tab.repository');
        foreach ($childrenTabs as $className) {
            $id_tab = version_compare(_PS_VERSION_, '8.0.0', '<')
                ? (int)Tab::getIdFromClassName($className)
                : $tabRepository->findOneIdByClassName($className);
            if ($id_tab) {
                $tab = new Tab($id_tab);
                $tab->delete();
            }
        }
        $id_parent_tab = version_compare(_PS_VERSION_, '8.0.0', '<')
            ? (int)Tab::getIdFromClassName('AdminEpakaParent')
            : $tabRepository->findOneIdByClassName('AdminEpakaParent');
        if ($id_parent_tab) {
            $tab = new Tab($id_parent_tab);
            return $tab->delete();
        }

        return true;
    }

    public function hookDisplayBackOfficeHeader($params)
    {
        $this->context->controller->addJquery();
        _PS_VERSION_ >= '8.0.0'
            ? $this->context->controller->addCSS($this->css_path . 'admin8.css')
            : $this->context->controller->addCSS($this->css_path . 'admin17.css');
        $this->context->controller->addJS($this->js_path . '_embed/jquery.dataTables.min.js');
        $this->context->controller->addJS($this->js_path . '_embed/leaflet.min.js');
        $this->context->controller->addJS($this->js_path . '_embed/dataTables.bootstrap5.min.js');
        $this->context->controller->addCSS($this->css_path . '_embed/dataTables.bootstrap5.min.css');
        $this->context->controller->addCSS($this->css_path . '_embed/leaflet.min.css');
        $this->context->controller->addJS($this->js_path . 'admin.js');
    }

    public function getOrderShippingCost($cart, $shipping_cost, $products = null, $id = null)
    {
        return $shipping_cost;
    }

    public function getOrderShippingCostExternal($cart)
    {
        return true;
    }

    public function hookActionCarrierUpdate($params) // Admin panel hook
    {
        $oldCarrierId = $params['id_carrier'];
        $container = PrestaShop\PrestaShop\Adapter\SymfonyContainer::getInstance();
        $em = $container->get('doctrine.orm.entity_manager');
        $epakaCarrier = $em->getRepository(EpakaCarrier::class)->findOneBy(['psCarrierId' => (int)$oldCarrierId]);
        $epakaSender = $em->getRepository(EpakaCarrier::class)->findOneBy(['psCarrierId' => (int)$oldCarrierId]);
        if ($epakaCarrier) {
            $carrier = $params['carrier'];
            $newCarrierId = $carrier->id;
            $epakaCarrier->setPsCarrierId((int)$newCarrierId);
            $epakaCarrier->setUpdatedAt((new DateTime('')));
            $em->flush();
        }
    }

    public function hookActionAdminControllerSetMedia($params)
    {
        $controllerName = Tools::getValue('controller');
        if ($controllerName === 'AdminCarriers') {
            $container = PrestaShop\PrestaShop\Adapter\SymfonyContainer::getInstance();
            $em = $container->get('doctrine.orm.entity_manager');
            $carriers = Carrier::getCarriers(
                $this->context->language->id,
                false,
                false,
                false,
                null,
                ALL_CARRIERS
            );
            usort($carriers, function ($a, $b){
                return $b['id_carrier'] <=> $a['id_carrier'];
            });
            $epakaCarriers = $em->getRepository(EpakaCarrier::class)->findAll();
            foreach ($epakaCarriers as $epakaCarrier) {
                foreach ($carriers as $carrier) {
                    if((int) $carrier['id_carrier'] === $epakaCarrier->getPsCarrierId()) {
                        continue 2;
                    }
                }
                $epakaSender =  $em->getRepository(EpakaSender::class)->findOneBy(['carrierId' => $epakaCarrier->getId()]);
                if($epakaSender) {
                    $epakaCarrier->setIsDeleted(true);
                    $em->flush();
                }
            }
            $em->flush();
        }
    }

    public function hookActionValidateOrderAfter($params)
    {
    }

    public function hookActionValidateOrder($params)
    {
        /**
         * @var $epakaCarrier EpakaCarrier
         * @var $epakaOrder EpakaOrder
         */
        $cart = $params['cart'];
        $order = $params['order'];
        $selectedPoint = $this->context->cookie->epaka_selected_point;
        $selectedPointName = $this->context->cookie->epaka_selected_point_name;
        if ($selectedPoint && $selectedPointName) {
            $idOrderCarrier = (int)$order->getIdOrderCarrier();
            if ($idOrderCarrier) {
                $orderCarrier = new OrderCarrier($idOrderCarrier);
                $orderCarrier->tracking_number = $selectedPoint;
                $orderCarrier->update();
            }
        }
        $this->context->cookie->__unset('epaka_selected_point');
        $this->context->cookie->__unset('epaka_selected_point_name');
        $this->context->cookie->write();
        $carrier = new Carrier($cart->id_carrier);
        $em = $this->get('doctrine.orm.entity_manager');
        $epakaCarrier = $em->getRepository(EpakaCarrier::class)->findOneBy(['psCarrierId' => (int)$carrier->id]);
        if (!$epakaCarrier) return;
        $epakaOrder = new EpakaOrder();
        $epakaOrder->setPsOrderId($order->id);
        $epakaOrder->setCreatedAt(new DateTime('now'));
        $epakaOrder->setUpdatedAt(new DateTime('now'));
        $em->persist($epakaOrder);
        $em->flush();
    }

    public function hookActionOrderHistoryAddAfter($params)
    {
        /**
         * @var $epakaOrderParcel EpakaParcel
         */
        $newOrderStatusId = $params['order_history']->id_order_state;
        $orderState = new OrderState($params['order_history']->id_order_state);
        $statusName = $orderState->name;
        $db = Db::getInstance();
        $cancelState = new OrderState((int)Configuration::get('PS_OS_CANCELED'), (int)$this->context->language->id);
        if (!$cancelState->id) {
            $cancelState->name = 'Canceled';
            $cancelState->color = '#FF0000';
            $cancelState->save();
        }
        $epakaOrder = $db->getRow('SELECT * FROM ' . _DB_PREFIX_ . 'epaka_order WHERE ps_order_id = ' . (int)$params['order_history']->id_order);
        if (current($statusName) === $cancelState->name) {
            if ($epakaOrder) {
                $db->execute(
                    'UPDATE ' . _DB_PREFIX_ . 'epaka_parcel 
                 SET is_deleted = 1 
                 WHERE epaka_order_id = ' . (int)$epakaOrder['id'] . ' 
                 AND is_deleted = 0'
                );
                $db->execute(
                    'UPDATE ' . _DB_PREFIX_ . 'epaka_order 
                 SET is_deleted = 1 
                 WHERE id = ' . (int)$epakaOrder['id']
                );
            }
        } else {
            if ($epakaOrder) {
                $db->execute(
                    'UPDATE ' . _DB_PREFIX_ . 'epaka_order 
                 SET is_deleted = 0 
                 WHERE id = ' . (int)$epakaOrder['id']
                );
            }
        }
    }
    public function hookAdditionalCustomerAddressFields($params)
    {
        if (!isset($params['fields'])) return;
        $fields = $params['fields'];
        if (isset($fields['address2'])) {
            $address2Field = $fields['address2'];
            $address2Field->setRequired(true);
            $address2Field->setLabel($this->trans('House number', [], 'Modules.Epaka.Epaka'));
        }
        if (isset($fields['phone'])) {
            $phoneField = $fields['phone'];
            $phoneField->setRequired(true);
            $phoneField->setLabel($this->trans('Phone', [], 'Modules.Epaka.Epaka'));
        }
    }

    public function hookActionValidateCustomerAddressForm($params)
    {
        $form = $params['form'];
        $fields = [
            "address1" => $params['form']->getField('address1')->getValue(),
            "address2" => $params['form']->getField('address2')->getValue(),
            "firstname" => $params['form']->getField('firstname')->getValue(),
            "lastname" => $params['form']->getField('lastname')->getValue(),
            "company" => $params['form']->getField('company')->getValue(),
            "postcode" => $params['form']->getField('postcode')->getValue(),
            "city" => $params['form']->getField('city')->getValue(),
            "phone" => $params['form']->getField('phone')->getValue(),
        ];
        foreach ($fields as $title => $value) {
            $charCount = mb_strlen($value);
            switch (true) {
                case $title === 'address1':
                    if ($charCount < ApiFieldLengthService::receiverAddress1Min()) {
                        $form->getField($title)->addError(
                            $this->trans('The address must be at least %min% characters long', [
                                '%min%' => ApiFieldLengthService::receiverAddress1Min()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    if ($charCount > ApiFieldLengthService::receiverAddress1Max()) {
                        $form->getField($title)->addError(
                            $this->trans('The address must not exceed %max% characters', [
                                '%max%' => ApiFieldLengthService::receiverAddress1Max()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    break;
                case $title === 'address2':
                    if ($charCount < ApiFieldLengthService::receiverAddress2Min()) {
                        $form->getField($title)->addError(
                            $this->trans('The house number must be at least %min% characters long', [
                                '%min%' => ApiFieldLengthService::receiverAddress2Min()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    if ($charCount > ApiFieldLengthService::receiverAddress2Max()) {
                        $form->getField($title)->addError(
                            $this->trans('The house number must not exceed %max% characters', [
                                '%max%' => ApiFieldLengthService::receiverAddress2Max()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    break;
                case $title === 'firstname':
                    if ($charCount < ApiFieldLengthService::receiverFirstnameMin()) {
                        $form->getField($title)->addError(
                            $this->trans('The firstname must be at least %min% characters long', [
                                '%min%' => ApiFieldLengthService::receiverFirstnameMin()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    if ($charCount > ApiFieldLengthService::receiverFirstnameMax()) {
                        $form->getField($title)->addError(
                            $this->trans('The firstname must not exceed %max% characters', [
                                '%max%' => ApiFieldLengthService::receiverFirstnameMax()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    break;
                case $title === 'lastname':
                    if ($charCount < ApiFieldLengthService::receiverLastnameMin()) {
                        $form->getField($title)->addError(
                            $this->trans('The lastname must be at least %min% characters long', [
                                '%min%' => ApiFieldLengthService::receiverLastnameMin()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    if ($charCount > ApiFieldLengthService::receiverLastnameMax()) {
                        $form->getField($title)->addError(
                            $this->trans('The lastname must not exceed %max% characters', [
                                '%max%' => ApiFieldLengthService::receiverLastnameMax()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    break;
                case $title === 'company' && !empty($value):
                    if ($charCount < ApiFieldLengthService::receiverCompanyMin()) {
                        $form->getField($title)->addError(
                            $this->trans('The company must be at least %min% characters long', [
                                '%min%' => ApiFieldLengthService::receiverCompanyMin()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    if ($charCount > ApiFieldLengthService::receiverCompanyMax()) {
                        $form->getField($title)->addError(
                            $this->trans('The company must not exceed %max% characters', [
                                '%max%' => ApiFieldLengthService::receiverCompanyMax()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    break;
                case $title === 'postcode':
                    if ($charCount < ApiFieldLengthService::receiverPostcodeMin()) {
                        $form->getField($title)->addError(
                            $this->trans('The postcode must be at least %min% characters long', [
                                '%min%' => ApiFieldLengthService::receiverPostcodeMin()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    if ($charCount > ApiFieldLengthService::receiverPostcodeMax()) {
                        $form->getField($title)->addError(
                            $this->trans('The postcode must not exceed %max% characters', [
                                '%max%' => ApiFieldLengthService::receiverPostcodeMax()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    break;
                case $title === 'city':
                    if ($charCount < ApiFieldLengthService::receiverCityMin()) {
                        $form->getField($title)->addError(
                            $this->trans('The city must be at least %min% characters long', [
                                '%min%' => ApiFieldLengthService::receiverCityMin()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    if ($charCount > ApiFieldLengthService::receiverCityMax()) {
                        $form->getField($title)->addError(
                            $this->trans('The city must not exceed %max% characters', [
                                '%max%' => ApiFieldLengthService::receiverCityMax()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    break;
                case $title === 'phone':
                    if ($charCount < ApiFieldLengthService::receiverPhoneMin()) {
                        $form->getField($title)->addError(
                            $this->trans('The phone must be at least %min% characters long', [
                                '%min%' => ApiFieldLengthService::receiverPhoneMin()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    if ($charCount > ApiFieldLengthService::receiverPhoneMax()) {
                        $form->getField($title)->addError(
                            $this->trans('The phone must not exceed %max% characters', [
                                '%max%' => ApiFieldLengthService::receiverPhoneMax()
                            ], 'Modules.Epaka.Epaka')
                        );
                    }
                    break;
            }
        }
    }

    public function hookActionFrontControllerSetMedia($params)
    {
        $this->context->controller->registerStylesheet(
            'epaka-front-css',
            'modules/' . $this->name . '/views/css/front/epaka.css',
            [
                'media' => 'all',
                'priority' => 100,
            ]
        );
        $this->context->controller->registerStylesheet(
            'epaka-leaflet-css',
            'modules/' . $this->name . '/views/css/front/leaflet.css',
            [
                'media' => 'all',
                'priority' => 100,
            ]
        );
        $this->context->controller->registerJavascript(
            'epaka-front-js',
            'modules/' . $this->name . '/views/js/front/epaka.js',
            [
                'position' => 'bottom',
                'priority' => 100,
            ]
        );
        $this->context->controller->registerJavascript(
            'epaka-leaflet-js',
            'modules/' . $this->name . '/views/js/front/leaflet.js',
            [
                'position' => 'bottom',
                'priority' => 100,
            ]
        );
    }

    public function hookDisplayCarrierExtraContent($params)
    {
        // !!! The maintenance mode must not be switched on !!!
        /**
         * @var $epakaCarrier EpakaCarrier
         */
        $carrierId = (int) $params['carrier']['id'];
        $carrierData = Db::getInstance()->getRow(
            'SELECT epaka_curier_id, additional_options, is_point
                 FROM ' . _DB_PREFIX_ . 'epaka_carrier
                 WHERE ps_carrier_id = ' . (int)$carrierId
        );
        $hasPoint = $carrierData['is_point'];
        if (!$hasPoint)  return '';
        $isCodOnlyToSearchPoints = '0';
        $epakaCurierId = $carrierData['epaka_curier_id'];
        $rawEpakaCurierAdditionalOptions = $carrierData['additional_options'];
        $epakaCurierAdditionalOptions = json_decode($rawEpakaCurierAdditionalOptions, true);
        if (is_array($epakaCurierAdditionalOptions)) {
            foreach ($epakaCurierAdditionalOptions as $name => $value) {
                if($name === 'cod') {
                    $isCodOnlyToSearchPoints = '1';
                    break;
                }
            }
        }
        $pointsUrl = $this->context->link->getModuleLink('epaka', 'loadpoints');
        $fetchPointMapUrl = $this->context->link->getModuleLink('epaka', 'fetchpointmap');
        $postData = [
            'carrierId' => $epakaCurierId,
            'isCod' => $isCodOnlyToSearchPoints,
            'pointsUrl' => $pointsUrl
        ];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $fetchPointMapUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        $fetchPointMapResponse = curl_exec($ch);
        curl_close($ch);

        return '
            <div class="carrier-extra-content epaka-map-container" data-carrier-id='.$epakaCurierId.' style="display: block !important">' . $fetchPointMapResponse . '</div>
        ';
    }

    /**
     * Clean up authorization entries before installation
     */
    private function cleanupAuthorizations()
    {
        // PS 8 uses authorization system
        if (version_compare(_PS_VERSION_, '8.0.0', '>=')) {
            $db = Db::getInstance();

            // Delete module authorizations
            $queries = [
                "DELETE FROM `" . _DB_PREFIX_ . "authorization_role` WHERE `slug` LIKE 'ROLE_MOD_MODULE_EPAKA_%'",
                "DELETE FROM `" . _DB_PREFIX_ . "access` WHERE `id_tab` IN (SELECT `id_tab` FROM `" . _DB_PREFIX_ . "tab` WHERE `module` = 'epaka')",
                "DELETE FROM `" . _DB_PREFIX_ . "module_access` WHERE `id_module` IN (SELECT `id_module` FROM `" . _DB_PREFIX_ . "module` WHERE `name` = 'epaka')"
            ];

            foreach ($queries as $query) {
                try {
                    $db->execute($query);
                } catch (Exception $e) {
                    // Ignore errors, just continue with cleanup
                }
            }
        }
    }
}
?>