<?php

class EpakaSavepointModuleFrontController extends ModuleFrontController
{
    public function init()
    {
        parent::init();
        if (!$this->context) {
            $this->context = Context::getContext();
        }
    }
    public function initContent()
    {
        parent::initContent();
        $rawData = Tools::file_get_contents('php://input');
        $data = json_decode($rawData, true);
        if (!empty($data['selected_point']) && !empty($data['selected_point_name'])) {
            $this->context->cookie->__set('epaka_selected_point', $data['selected_point']);
            $this->context->cookie->__set('epaka_selected_point_name', $data['selected_point_name']);
            $this->context->cookie->write();
            $this->ajaxDie(json_encode([
                'success' => true,
                'message' => 'Selected point saved successfully in cookie.'
            ]));
        } else {
            $this->ajaxDie(json_encode([
                'success' => false,
                'message' => 'No data provided.'
            ]));
        }
    }
}
