<?php

use Epaka\Service\ApiService;

class EpakaLoadpointsModuleFrontController extends ModuleFrontController
{
    public function init()
    {
        parent::init();
        if (!$this->context) {
            $this->context = Context::getContext();
        }
    }

    public function initContent()
    {
        parent::initContent();
        $rawData = file_get_contents('php://input');
        $postData = json_decode($rawData, true);
        if ($postData && is_array($postData)) {
            $carrierId      = isset($postData['courier']) ? (int)$postData['courier'] : 0;
            $country        = isset($postData['country']) ? $postData['country'] : 'PL';
            $lat            = isset($postData['lat']) ? (float)$postData['lat'] : 52.2298;
            $lon            = isset($postData['lon']) ? (float)$postData['lon'] : 21.0122;
            $codOnly        = (bool) $postData['isCod'];
            $function       = 'odbior';
            $withoutPrinter = false;
            $showPoints     = false;
            $showMachines   = isset($postData['showMachines']) ? (bool)$postData['showMachines'] : true;
        } else {
            $carrierId      = (int)Tools::getValue('courier', 0);
            $country        = Tools::getValue('country', 'PL');
            $lat            = (float)Tools::getValue('lat', 52.2298);
            $lon            = (float)Tools::getValue('lon', 21.0122);
            $codOnly        = (bool) $postData['isCod'];
            $function       = 'odbior';
            $withoutPrinter = false;
            $showPoints     = false;
            $showMachines   = Tools::getValue('showMachines', true);
        }
        $url = ApiService::DEFAULT_MAP_URL ."/map_popup/getPoints?" .
            "courier={$carrierId}" .
            "&country=" . urlencode($country) .
            "&lat={$lat}" .
            "&lon={$lon}" .
            "&cod_only=" . ($codOnly ? 'true' : 'false') .
            "&function=" . urlencode($function) .
            "&withoutPrinter=" . ($withoutPrinter ? 'true' : 'false') .
            "&showPoints=" . ($showPoints ? 'true' : 'false') .
            "&showMachines=" . ($showMachines ? 'true' : 'false');
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        $mapResponse = curl_exec($ch);
        if (curl_errno($ch)) {
            $error = curl_error($ch);
            curl_close($ch);
            $this->ajaxDie(json_encode(['error' => $error], JSON_PRETTY_PRINT));
        }
        curl_close($ch);
        $this->ajaxDie($mapResponse);
    }
}