<?php

class EpakaFetchpointmapModuleFrontController extends ModuleFrontController
{
    public function init()
    {
        parent::init();
        if (!$this->context) {
            $this->context = Context::getContext();
        }
        if (!$this->context->currency) {
            $this->context->currency = new Currency(Configuration::get('PS_CURRENCY_DEFAULT'));
        }
        if (!$this->context->language) {
            $this->context->language = new Language(Configuration::get('PS_LANG_DEFAULT'));
        }
    }

    public function initContent()
    {
        parent::initContent();
        $rawData = Tools::file_get_contents('php://input');
        $requestData = json_decode($rawData, true);
        if (!isset($requestData['carrierId']) || !isset($requestData['pointsUrl'])) {
            $this->ajaxDie(json_encode(['error' => 'Invalid request data']));
        }
        $carrierId = (int) $requestData['carrierId'];
        $isCod = $requestData['isCod'];
        $pointsUrl = $requestData['pointsUrl'];
        $savePointUrl = $this->context->link->getModuleLink('epaka', 'savepoint');
        $this->context->smarty->assign([
            'carrierId' => $carrierId,
            'isCod' => (bool) $isCod,
            'pointsUrl' => $pointsUrl,
            'savePointUrl' => $savePointUrl,
        ]);
        $this->setTemplate('module:epaka/views/templates/front/fetchpointmap.tpl');
    }
}