<?php

use Epaka\Service\CryptoService;

class EpakaCronModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();
        $tokenRaw = Tools::getValue('token');
        $siteUrl = Context::getContext()->shop->getBaseURL(true, true);
        try {
            $token = CryptoService::decryptStatic($tokenRaw, 'bC15HarSft');
        } catch (Exception $e) {
            die('Unauthorized access');
        }
        if ($token !== $siteUrl) {
            die('Unauthorized access');
        }
        $this->ajax = true;
        try {
            Epaka\Service\EpakaOrderStatusUpdateService::updateStatuses();
            die('Cron task completed successfully');
        } catch (Exception $e) {
            PrestaShopLogger::addLog('Epaka Cron Error: ' . $e->getMessage(), 3);
            die('Cron task failed: ' . $e->getMessage());
        }
    }
}